/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.reflection;

import org.robotframework.javalib.reflection.IArgumentGrouper;
import org.robotframework.javalib.util.ArrayUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentGrouper
implements IArgumentGrouper {
    private final Class<?>[] parameterTypes;

    public ArgumentGrouper(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    @Override
    public Object[] groupArguments(Object[] ungroupedArguments) {
        if (this.shouldGroupArguments(ungroupedArguments)) {
            return this.extractArguments(this.asStrings(ungroupedArguments));
        }
        return ungroupedArguments;
    }

    private boolean shouldGroupArguments(Object[] ungroupedArguments) {
        return !this.shouldNotGroupArguments(ungroupedArguments);
    }

    private boolean shouldNotGroupArguments(Object[] ungroupedArguments) {
        return ungroupedArguments == null || this.parameterTypes.length == 0 || this.parameterTypes.length == ungroupedArguments.length && !this.lastArgIsAnArray();
    }

    private String[] asStrings(Object[] ungroupedArguments) {
        String[] argsAsString = new String[ungroupedArguments.length];
        for (int i = 0; i < ungroupedArguments.length; ++i) {
            argsAsString[i] = ungroupedArguments[i].toString();
        }
        return argsAsString;
    }

    private Object[] extractArguments(Object[] ungroupedArguments) {
        Object[] beginningOfarguments = this.extractBeginningOfArguments(ungroupedArguments);
        Object[] extractedArguments = new Object[beginningOfarguments.length + 1];
        for (int i = 0; i < beginningOfarguments.length; ++i) {
            extractedArguments[i] = beginningOfarguments[i];
        }
        extractedArguments[extractedArguments.length - 1] = this.extractRestOfArguments(ungroupedArguments);
        return extractedArguments;
    }

    private Object[] extractBeginningOfArguments(Object[] ungroupedArguments) {
        return ArrayUtil.copyOfRange(ungroupedArguments, 0, this.parameterTypes.length - 1);
    }

    private Object[] extractRestOfArguments(Object[] ungroupedArguments) {
        return ArrayUtil.copyOfRange(ungroupedArguments, this.parameterTypes.length - 1, ungroupedArguments.length);
    }

    private boolean lastArgIsAnArray() {
        return this.parameterTypes[this.parameterTypes.length - 1].isArray();
    }
}

