/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Assert;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil {
    static /* synthetic */ Class array$Ljava$lang$Object;

    public static boolean arrayContains(String needle, String[] haystack) {
        for (int i = 0; i < haystack.length; ++i) {
            if (!haystack[i].equals(needle)) continue;
            return true;
        }
        return false;
    }

    public static void assertArraysContainSame(String[] expected, String[] actual) {
        Assert.assertEquals(new HashSet<String>(Arrays.asList(expected)), new HashSet<String>(Arrays.asList(actual)));
    }

    public static <T> void assertArraysEquals(T[] expected, T[] actual) {
        Assert.assertTrue((String)new StringBuffer().append("Expected ").append(Arrays.asList(expected)).append(" but was ").append(Arrays.asList(actual)).toString(), (boolean)Arrays.equals(expected, actual));
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(new StringBuffer().append(from).append(" > ").append(to).toString());
        }
        Class<?> clazz = array$Ljava$lang$Object;
        if (clazz == null) {
            clazz = array$Ljava$lang$Object = new Object[0].getClass();
        }
        Object[] copy = newType == clazz ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return ArrayUtil.copyOfRange(original, from, to, original.getClass());
    }

    public static <T> T[] add(T[] original, T[] newElements) {
        ArrayList results = new ArrayList(original.length + newElements.length);
        CollectionUtils.addAll(results, (Object[])original);
        CollectionUtils.addAll(results, (Object[])newElements);
        return results.toArray(original);
    }
}

