/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.button;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.button.ButtonOperator;
import org.robotframework.swing.button.ButtonOperatorFactory;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class ButtonKeywords {
    public static final String __PARANAMER_DATA = "\ngetButtonText java.lang.String identifier \n\nbuttonShouldBeDisabled java.lang.String identifier \n\nbuttonShouldBeEnabled java.lang.String identifier \n\nbuttonShouldExist java.lang.String identifier \n\nbuttonShouldNotExist java.lang.String identifier \n\npushButton java.lang.String identifier \n";
    private IdentifierParsingOperatorFactory<ButtonOperator> operatorFactory = new ButtonOperatorFactory();
    private IComponentConditionResolver buttonExistenceResolver = new ComponentExistenceResolver(this.operatorFactory);

    @RobotKeyword(value="Uses current context to search for a button and when found, pushes it.\n\nExample:\n| Push Button | _OK_ |\n")
    public void pushButton(String identifier) {
        this.createOperator(identifier).push();
    }

    @RobotKeyword(value="Uses current context to search for a button and when found, returns the text it is labeled with.\n\nExample:\n| ${buttonText}=  | Get Button Text | _myButton_    |\n| Should Be Equal | _My Button_     | _${buttonText}_ |\n")
    public String getButtonText(String identifier) {
        return this.createOperator(identifier).getText();
    }

    @RobotKeyword(value="Fails if button does not exist within current context.\n\nExample:\n| Button Should Exist | _OK_ |\n")
    public void buttonShouldExist(String identifier) {
        Assert.assertTrue((String)("Button '" + identifier + "' doesn't exist"), (boolean)this.buttonExists(identifier));
    }

    @RobotKeyword(value="Fails if button exists within current context.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`.\n\nExample:\n| Set Jemmy Timeouts      | _1_  |\n| Button Should Not Exist | _OK_ |\n")
    public void buttonShouldNotExist(String identifier) {
        Assert.assertFalse((String)("Button '" + identifier + "' exists"), (boolean)this.buttonExists(identifier));
    }

    @RobotKeyword(value="Fails if button is disabled\n\nExample:\n| Button Should Be Enabled | _OK_ |\n")
    public void buttonShouldBeEnabled(String identifier) {
        Assert.assertTrue((String)"Button was disabled.", (boolean)this.createOperator(identifier).isEnabled());
    }

    @RobotKeyword(value="Fails if button is enabled\n\nExample:\n| Button Should Be Disabled | _OK_ |\n")
    public void buttonShouldBeDisabled(String identifier) {
        Assert.assertFalse((String)"Button was enabled.", (boolean)this.createOperator(identifier).isEnabled());
    }

    private ButtonOperator createOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }

    private boolean buttonExists(String identifier) {
        return this.buttonExistenceResolver.satisfiesCondition(identifier);
    }
}

