/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.checkbox;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.checkbox.CheckBoxOperator;
import org.robotframework.swing.checkbox.CheckBoxOperatorFactory;
import org.robotframework.swing.factory.OperatorFactory;

@RobotKeywords
public class CheckBoxKeywords {
    public static final String __PARANAMER_DATA = "\ncheckBoxShouldBeChecked java.lang.String identifier \n\ncheckBoxShouldBeDisabled java.lang.String identifier \n\ncheckBoxShouldBeEnabled java.lang.String identifier \n\ncheckBoxShouldBeUnchecked java.lang.String identifier \n\ncheckBoxShouldNotBeChecked java.lang.String identifier \n\ncheckCheckBox java.lang.String identifier \n\nuncheckCheckBox java.lang.String identifier \n";
    private OperatorFactory<CheckBoxOperator> operatorFactory = new CheckBoxOperatorFactory();

    @RobotKeyword(value="Uses current context to search for a checkbox and when found, checks it.\n\nExample:\n| Check Checkbox | _My Checkbox_ |\n")
    public void checkCheckBox(String identifier) {
        this.createOperator(identifier).changeSelection(true);
    }

    @RobotKeyword(value="Uses current context to search for a checkbox and when found, unchecks it.\n\nExample:\n| Uncheck Checkbox | _My Checkbox_ |\n")
    public void uncheckCheckBox(String identifier) {
        this.createOperator(identifier).changeSelection(false);
    }

    @RobotKeyword(value="Fails if checkbox is not checked.\n\nExample:\n| Check Box Should Be Checked | _My Checkbox_ |\n")
    public void checkBoxShouldBeChecked(String identifier) {
        Assert.assertTrue((boolean)this.createOperator(identifier).isSelected());
    }

    @RobotKeyword(value="Fails if checkbox is checked.\n\nExample:\n| Check Box Should Be Unchecked | _My Checkbox_ |\n")
    public void checkBoxShouldBeUnchecked(String identifier) {
        Assert.assertFalse((boolean)this.createOperator(identifier).isSelected());
    }

    @RobotKeyword(value="Fails if checkbox is disabled.\n\nExample:\n| Check Box Should Be Enabled | _My Checkbox_ |\n")
    public void checkBoxShouldBeEnabled(String identifier) {
        Assert.assertTrue((String)("Checkbox '" + identifier + "' is disabled."), (boolean)this.createOperator(identifier).isEnabled());
    }

    @RobotKeyword(value="Fails if checkbox is enabled.\n\nExample:\n| Check Box Should Be Disabled | _My Checkbox_ |\n")
    public void checkBoxShouldBeDisabled(String identifier) {
        Assert.assertFalse((String)("Checkbox '" + identifier + "' is enabled."), (boolean)this.createOperator(identifier).isEnabled());
    }

    @RobotKeyword(value="Alias for `Check Box Should Be Unchecked` keyword.\n")
    public void checkBoxShouldNotBeChecked(String identifier) {
        this.checkBoxShouldBeUnchecked(identifier);
    }

    private CheckBoxOperator createOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }
}

