/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.combobox;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.combobox.ComboBoxOperator;
import org.robotframework.swing.combobox.ComboBoxOperatorFactory;
import org.robotframework.swing.factory.OperatorFactory;

@RobotKeywords
public class ComboBoxKeywords {
    public static final String __PARANAMER_DATA = "\ngetSelectedItemFromComboBox java.lang.String identifier \n\ngetSelectedItemFromDropdownMenu java.lang.String identifier \n\ncomboBoxShouldBeDisabled java.lang.String identifier \n\ncomboBoxShouldBeEnabled java.lang.String identifier \n\nselectFromComboBox java.lang.String,java.lang.String identifier,comboItemIdentifier \n\nselectFromDropdownMenu java.lang.String,java.lang.String menuIdentifier,menuItemIdentifier \n\ntypeIntoCombobox java.lang.String,java.lang.String identifier,text \n";
    private OperatorFactory<ComboBoxOperator> operatorFactory = new ComboBoxOperatorFactory();

    @RobotKeyword(value="Selects an item from a combobox.\nNB. If the _comboItemIdentifier_ is a numerical value it vill be interpreted as index.\nExample:\n| Select From Combo Box | _myComboBox_ | _myItem_ | # Selects _'myItem'_ from combobox |\n| Select From Combo Box | _myComboBox_ | _0_      | # Selects the first item from combobox |\n")
    public void selectFromComboBox(String identifier, String comboItemIdentifier) {
        this.createOperator(identifier).selectItem(comboItemIdentifier);
    }

    @RobotKeyword(value="Alias for `Select From Combobox` keyword.\n")
    public void selectFromDropdownMenu(String menuIdentifier, String menuItemIdentifier) {
        this.selectFromComboBox(menuIdentifier, menuItemIdentifier);
    }

    @RobotKeyword(value="Returns an item from a combobox.\n\nExample:\n| ${selectedItem}= | Get Selected Item From Combobox | _myComboBox_      |\n| Should Be Equal  | _item three_                    | _${selectedItem}_ |\n")
    public Object getSelectedItemFromComboBox(String identifier) {
        return this.createOperator(identifier).getSelectedItem();
    }

    @RobotKeyword(value="Alias for `Get Selected Item From Combobox` keyword.\n")
    public Object getSelectedItemFromDropdownMenu(String identifier) {
        return this.getSelectedItemFromComboBox(identifier);
    }

    @RobotKeyword(value="Fails if combobox is disabled\n\nExample:\n| Combobox Should Be Enabled | _OK_ |\n")
    public void comboBoxShouldBeEnabled(String identifier) {
        Assert.assertTrue((String)("Combobox '" + identifier + "' was disabled."), (boolean)this.createOperator(identifier).isEnabled());
    }

    @RobotKeyword(value="Fails if combobox is enabled\n\nExample:\n| Combobox Should Be Disabled | _OK_ |\n")
    public void comboBoxShouldBeDisabled(String identifier) {
        Assert.assertFalse((String)("Combobox '" + identifier + "' was enabled."), (boolean)this.createOperator(identifier).isEnabled());
    }

    @RobotKeyword(value="Types text into a combobox.\nExample:\n| Type Into Combobox | _myCombobox_ | _someValue_ |\n")
    public void typeIntoCombobox(String identifier, String text) {
        this.createOperator(identifier).typeText(text);
    }

    private ComboBoxOperator createOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }
}

