/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.development;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.operator.ComponentWrapper;

@RobotKeywords
public class DevelopmentKeywords {
    public static final String __PARANAMER_DATA = "\nlistComponentsInContext \n";
    private List<String> resultComponentList = new ArrayList<String>();

    @RobotKeyword(value="Prints components (their types and their internal names) from the selected context.\nSee keywords, `Select Window`, `Select Dialog` and `Select Context` for details about context.\n\nExample:\n| Select Main Window         |\n| List Components In Context |\n")
    public String listComponentsInContext() {
        ComponentWrapper operator = Context.getContext();
        new ContainerIteratorForListing((Container)operator.getSource()).iterate();
        return this.resultComponentList.toString();
    }

    private void printSpacesToFormatOutputAsTree(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("   ");
        }
    }

    private String componentToString(Component component) {
        String componentString = component.toString();
        int indexToStartOfDetails = componentString.indexOf(91);
        if (indexToStartOfDetails == -1) {
            return componentString;
        }
        return componentString.substring(0, indexToStartOfDetails);
    }

    private static abstract class ContainerIterator {
        public static final String __PARANAMER_DATA = "\n<init> java.awt.Container container \n\niterate \n\noperateOnComponent java.awt.Component,int component,level \n";
        private int level;
        private Container container;

        public ContainerIterator(Container container) {
            this.container = container;
        }

        public void iterate() {
            this.processComponent(this.container);
        }

        public abstract void operateOnComponent(Component var1, int var2);

        private void processComponent(Component component) {
            this.operateOnComponent(component, this.level);
            ++this.level;
            if (component instanceof Container) {
                Component[] subComponents = ((Container)component).getComponents();
                for (int i = 0; i < subComponents.length; ++i) {
                    this.processComponent(subComponents[i]);
                    --this.level;
                }
            }
        }
    }

    private class ContainerIteratorForListing
    extends ContainerIterator {
        public static final String __PARANAMER_DATA = "\n<init> java.awt.Container container \n\noperateOnComponent java.awt.Component,int component,level \n";

        public ContainerIteratorForListing(Container container) {
            super(container);
        }

        public void operateOnComponent(Component component, int level) {
            DevelopmentKeywords.this.printSpacesToFormatOutputAsTree(level);
            String componentName = DevelopmentKeywords.this.componentToString(component);
            System.out.println(level + " " + componentName + ": " + component.getName());
            DevelopmentKeywords.this.resultComponentList.add(componentName);
        }
    }
}

