/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.launch;

import java.lang.reflect.Method;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;

@RobotKeywords
public class ApplicationLaunchingKeywords {
    public static final String __PARANAMER_DATA = "\nlaunchApplication java.lang.String,java.lang.String[] className,args \n\nstartApplication java.lang.String,java.lang.String[] className,args \n\nstartApplicationInSeparateThread java.lang.String,java.lang.String[] className,args \n";

    @RobotKeyword(value="Launches application with the given arguments.\n\nExample:\n| Launch Application | _com.acme.myapplication.MyApp_ | _C:\\data.txt_ |\n")
    @ArgumentNames(value={"className", "*args"})
    public void launchApplication(String className, String[] args) throws Exception {
        Method mainMethod = this.getMainMethod(className);
        mainMethod.invoke(null, new Object[]{args});
    }

    @RobotKeyword(value="Alias for `Launch Application` keyword\n")
    @ArgumentNames(value={"className", "*args"})
    public void startApplication(String className, String[] args) throws Exception {
        this.launchApplication(className, args);
    }

    @RobotKeyword(value="Launches application in a separate thread with the given arguments.\nThis is useful if your application does something that blocks eg. opens up a dialog.\n\nExample:\n| Start Application In Separate Thread | _com.acme.myapplication.MyApp_ |\n")
    @ArgumentNames(value={"className", "*args"})
    public void startApplicationInSeparateThread(final String className, final String[] args) throws Exception {
        this.createThread(new Runnable(){

            public void run() {
                try {
                    ApplicationLaunchingKeywords.this.launchApplication(className, args);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
    }

    Thread createThread(Runnable runnable) {
        return new Thread(runnable);
    }

    private Method getMainMethod(String className) throws ClassNotFoundException {
        Class<?> clss = Class.forName(className);
        try {
            return clss.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Class '" + className + "' doesn't have a main method.");
        }
    }
}

