/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.common.IdentifierSupport;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.list.ListOperator;
import org.robotframework.swing.list.ListOperatorFactory;

@RobotKeywords
public class ListKeywords
extends IdentifierSupport {
    public static final String __PARANAMER_DATA = "\ngetListItemCount java.lang.String identifier \n\ngetSelectedValueFromList java.lang.String identifier \n\nclearSelectionFromList java.lang.String identifier \n\nclickOnListItem java.lang.String,java.lang.String,java.lang.String[] identifier,listItemIdentifier,clickCount \n\nselectAllListItems java.lang.String identifier \n\nselectFromList java.lang.String,java.lang.String,java.lang.String[] identifier,listItemIdentifier,additionalItemIdentifiers \n";
    private OperatorFactory<ListOperator> operatorFactory = new ListOperatorFactory();

    @RobotKeyword(value="Clears selection from list.\n\nExample:\n| Clear Selection From List | _myList_ |\n")
    public void clearSelectionFromList(String identifier) {
        this.createOperator(identifier).clearSelection();
    }

    @RobotKeyword(value="Selects an item from the list.\n\nExamples:\n| Select From List | _myList_ | _myItem_ | # selects 'myItem'                   |\n| Select From List | _myList_ | _0_      | # selects the first item in the list |\n\n| Select From List | _myList_ | _myItem_ | _2_ | # doubleclicks on item |\nAny number of list item identifiers can be provided to select multiple items at once:\n| Select From List | _myList_ | _myItem_ | _anotherItem_ | _yetAnother_ |\n")
    @ArgumentNames(value={"identifier", "listItemIdentifier", "*additionalItemIdentifiers"})
    public void selectFromList(String identifier, final String listItemIdentifier, String[] additionalItemIdentifiers) {
        ArrayList<String> itemIdentifiers = new ArrayList<String>(){
            {
                this.add(listItemIdentifier);
            }
        };
        CollectionUtils.addAll((Collection)itemIdentifiers, (Object[])additionalItemIdentifiers);
        this.createOperator(identifier).selectItems((List<String>)itemIdentifiers);
    }

    @RobotKeyword(value="Clicks on a list item.\n\nExamples:\n| Click On List Item | _myList_ | _myItem_ |\n| Click On List Item | _myList_ | _0_      | \n\nAn optional _click count_ parameter can be provided for example if a double click is required.\nDefault click count is one:\n| Click On List Item | _myList_ | _myItem_ | _2_ | # doubleclicks on item |\n")
    @ArgumentNames(value={"identifier", "listItemIdentifier", "clickCount=1"})
    public void clickOnListItem(String identifier, String listItemIdentifier, String[] clickCount) {
        this.createOperator(identifier).clickOnItem(listItemIdentifier, this.extractIntArgument(clickCount));
    }

    @RobotKeyword(value="Returns the item that's currently selected in the list.\n\nExample:\n| ${listItem}=    | Get Selected Value From List | _myList_      |\n| Should Be Equal | _Expected Item_              | _${listItem}_ |\n")
    public Object getSelectedValueFromList(String identifier) {
        return this.createOperator(identifier).getSelectedValue();
    }

    @RobotKeyword(value="Returns the number of items contained in list.\n\nExample:\n| ${listItemCount}=    | Get List Item Count | _myList_      |\n| Should Be Equal As Integers | _2_ | _${listItemCount}_ |\n")
    public int getListItemCount(String identifier) {
        return this.createOperator(identifier).getSize();
    }

    @RobotKeyword(value="Selects all list items.\n\nExample:\n| Select All List Items | _My List_ |\n")
    public void selectAllListItems(String identifier) {
        this.createOperator(identifier).selectAll();
    }

    private ListOperator createOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }
}

