/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.menu;

import junit.framework.Assert;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.arguments.ArgumentParser;
import org.robotframework.swing.menu.MenuSupport;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RobotKeywords
public class MenuKeywords
extends MenuSupport {
    public static final String __PARANAMER_DATA = "\nmenuItemShouldBeDisabled java.lang.String menuPath \n\nmenuItemShouldBeEnabled java.lang.String menuPath \n\nmenuItemShouldExist java.lang.String menuPath \n\nmenuItemShouldNotBeEnabled java.lang.String menuPath \n\nmenuItemShouldNotExist java.lang.String menuPath \n\nselectFromMenu java.lang.String menuPath \n\nselectFromMenuAndWait java.lang.String menuPath \n";

    @RobotKeyword(value="Selects an item from the menu of the currently selected window.\n\nExample:\n| Select Window    | _My Application_           |\n| Select From Menu | _Tools|Testing|MyTestTool_ |\n")
    public void selectFromMenu(String menuPath) {
        this.showMenuItem(menuPath).pushNoBlock();
    }

    @RobotKeyword(value="Selects an item from the menu of the currently selected window and waits for action to finish.\nThis keyword will not work, for example, if the menu item opens a dialog.\n\nExample:\n| Select Window             | _My Application_           |\n| Select From Menu And Wait | _Tools|Testing|MyTestTool_ |\n")
    public void selectFromMenuAndWait(String menuPath) {
        this.showMenuItem(menuPath).push();
    }

    @RobotKeyword(value="Searches for an menu item from the menu of the currently selected window and fails if it is disabled.\n\nExample:\n| Select Window               | _My Application_           |\n| Menu Item Should Be Enabled | _Tools|Testing|MyTestTool_ |\n")
    public void menuItemShouldBeEnabled(String menuPath) {
        Assert.assertTrue((String)("Menu item '" + menuPath + "' is disabled."), (boolean)this.menuIsEnabled(menuPath));
    }

    @RobotKeyword(value="Searches for an menu item from the menu of the currently selected window and fails if it is enabled.\n\nExample:\n| Select Window                   | _My Application_           |\n| Menu Item Should Not Be Enabled | _Tools|Testing|MyTestTool_ |\n")
    public void menuItemShouldNotBeEnabled(String menuPath) {
        Assert.assertFalse((String)("Menu item '" + menuPath + "' is enabled."), (boolean)this.menuIsEnabled(menuPath));
    }

    @RobotKeyword(value="Alias for `Menu Item Should Not Be Enabled`\n")
    public void menuItemShouldBeDisabled(String menuPath) {
        this.menuItemShouldNotBeEnabled(menuPath);
    }

    @RobotKeyword(value="Fails if menu item doesn't exist.\n\nExample:\n| Menu Item Should Exist | _Tools|Testing|Test Tool_ |\n")
    public void menuItemShouldExist(String menuPath) {
        Assert.assertTrue((String)("Menu item '" + menuPath + "' does not exist."), (boolean)this.menuExists(menuPath));
    }

    @RobotKeyword(value="Fails if menu item exists.\n\nExample:\n| Menu Item Should Not Exist | _Tools|Testing|Test Tool_ |\n")
    public void menuItemShouldNotExist(String menuPath) {
        Assert.assertFalse((String)("Menu item '" + menuPath + "' exists."), (boolean)this.menuExists(menuPath));
    }

    private Boolean menuExists(final String menuPath) {
        return this.getFromMenuItem(new MenuAction<Boolean>(){

            @Override
            public Boolean doWithMenuItem() {
                IComponentConditionResolver existenceResolver = MenuKeywords.this.createMenuItemExistenceResolver();
                return existenceResolver.satisfiesCondition(menuPath);
            }
        });
    }

    private Boolean menuIsEnabled(final String menuPath) {
        return this.getFromMenuItem(new MenuAction<Boolean>(){

            @Override
            public Boolean doWithMenuItem() {
                return MenuKeywords.this.showMenuItem(menuPath).isEnabled();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getFromMenuItem(MenuAction<T> action) {
        try {
            T t = action.doWithMenuItem();
            return t;
        }
        finally {
            this.closeMenu();
        }
    }

    private void closeMenu() {
        this.menubarOperator().pressMouse();
    }

    IComponentConditionResolver createMenuItemExistenceResolver() {
        ArgumentParser<JMenuItemOperator> menuItemOperatorFactory = new ArgumentParser<JMenuItemOperator>(){

            @Override
            public JMenuItemOperator parseArgument(String menuPath) {
                return MenuKeywords.this.showMenuItem(menuPath);
            }
        };
        return new ComponentExistenceResolver(menuItemOperatorFactory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MenuAction<T> {
        public T doWithMenuItem();
    }
}

