/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.spinner;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.spinner.SpinnerOperator;
import org.robotframework.swing.spinner.SpinnerOperatorFactory;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class SpinnerKeywords {
    public static final String __PARANAMER_DATA = "\ngetSpinnerValue java.lang.String identifier \n\ndecreaseSpinnerValue java.lang.String,java.lang.String[] identifier,times \n\nincreaseSpinnerValue java.lang.String,java.lang.String[] identifier,times \n\nspinnerShouldExist java.lang.String identifier \n\nspinnerShouldNotExist java.lang.String identifier \n";
    private IdentifierParsingOperatorFactory<SpinnerOperator> operatorFactory = new SpinnerOperatorFactory();
    private IComponentConditionResolver existenceResolver = new ComponentExistenceResolver(this.operatorFactory);

    @RobotKeyword(value="Fails if spinner does not exist within current context.\n\nExample:\n| Spinner Should Exist | _dateSpinner_ |\n")
    public void spinnerShouldExist(String identifier) {
        Assert.assertTrue((String)("Spinner '" + identifier + "' doesn't exist."), (boolean)this.existenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Fails if spinner exists within current context.\n\nExample:\n| Spinner Should Not Exist | _dateSpinner_ |\n")
    public void spinnerShouldNotExist(String identifier) {
        Assert.assertFalse((String)("Spinner '" + identifier + "' exists."), (boolean)this.existenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Scrolls spinner button up.\nThe number of notches to scroll can be given as a second argument.\n\nExamle:\n| Increase Spinner Value | _mySpinner_ |   | # scrolls spinner button up a notch |\n| Increase Spinner Value | _mySpinner_ | 4 | # scrolls spinner button up four notches |\n")
    @ArgumentNames(value={"identifier", "times=1"})
    public void increaseSpinnerValue(String identifier, String[] times) {
        this.increase(this.operatorFactory.createOperator(identifier), this.getNotches(times));
    }

    @RobotKeyword(value="Scrolls spinner button down.\nThe number of notches to scroll can be given as a second argument.\n\nExamle:\n| Decrease Spinner Value | _mySpinner_ |   | # scrolls spinner button down a notch |\n| Decrease Spinner Value | _mySpinner_ | 4 | # scrolls spinner button down four notches |\n")
    @ArgumentNames(value={"identifier", "times=1"})
    public void decreaseSpinnerValue(String identifier, String[] times) {
        this.decrease(this.operatorFactory.createOperator(identifier), this.getNotches(times));
    }

    @RobotKeyword(value="Uses current context to search for a spinner button and when found, returns its current value.\n\nExample:\n| ${spinnerValue}=  | Get Spinner Value | _mySpinner_    |\n| Should Be Equal As Integers | _12_     | _${spinnerValue}_ |\n")
    public Object getSpinnerValue(String identifier) {
        return this.operatorFactory.createOperator(identifier).getValue();
    }

    private void increase(SpinnerOperator spinnerOperator, int numberOfIncreases) {
        for (int i = 0; i < numberOfIncreases; ++i) {
            spinnerOperator.increase();
        }
    }

    private void decrease(SpinnerOperator spinnerOperator, int numberOfDecreases) {
        for (int i = 0; i < numberOfDecreases; ++i) {
            spinnerOperator.decrease();
        }
    }

    private int getNotches(String[] times) {
        return times.length == 0 ? 1 : Integer.parseInt(times[0]);
    }
}

