/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.textcomponent;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.textcomponent.TextComponentOperator;
import org.robotframework.swing.textcomponent.TextComponentOperatorFactory;

@RobotKeywords
public class TextComponentKeywords {
    public static final String __PARANAMER_DATA = "\ngetTextFieldValue java.lang.String identifier \n\nclearTextField java.lang.String identifier \n\ninsertIntoTextField java.lang.String,java.lang.String identifier,text \n\ntextFieldShouldBeDisabled java.lang.String identifier \n\ntextFieldShouldBeEnabled java.lang.String identifier \n\ntypeIntoTextField java.lang.String,java.lang.String identifier,text \n";
    private OperatorFactory<TextComponentOperator> operatorFactory = new TextComponentOperatorFactory();

    @RobotKeyword(value="Inserts text into a text component.\n\nExample:\n| Insert Into Textfield | _nameTextField_ | _John Doe_ |\n")
    public void insertIntoTextField(String identifier, String text) {
        this.createOperator(identifier).setText(text);
    }

    @RobotKeyword(value="Returns the value of a text component.\n\nExample:\n| ${textFieldValue}= | Get Textfield Value | _nameTextField_       |\n| Should Be Equal    | _John Doe_          | _${textFieldValue}_ |\n")
    public String getTextFieldValue(String identifier) {
        return this.createOperator(identifier).getText();
    }

    @RobotKeyword(value="Types text into a text component.\nSame as `Insert Into Textfield` but sends real key events when setting text field contents.\nUseful if application expects real keyboard events instead of only setting the text of the textfield.\n\nExample:\n| Type Into Textfield | _nameTextField_ | _John Doe_ |\n")
    public void typeIntoTextField(String identifier, String text) {
        this.createOperator(identifier).typeText(text);
    }

    @RobotKeyword(value="Clears text field contents.\n\nExample:\n| Clear Textfield | _nameTextField_ |\n")
    public void clearTextField(String identifier) {
        this.createOperator(identifier).clearText();
    }

    @RobotKeyword(value="Fails if text component is disabled.\n\nExample:\n| Textfield Should Be Enabled | _nameTextField_ |\n")
    public void textFieldShouldBeEnabled(String identifier) {
        Assert.assertTrue((String)("Textfield '" + identifier + "' is disabled."), (boolean)this.createOperator(identifier).isEnabled());
    }

    @RobotKeyword(value="Fails if text component is enabled.\n\nExample:\n| Textfield Should Be Disabled | _nameTextField_ |\n")
    public void textFieldShouldBeDisabled(String identifier) {
        Assert.assertFalse((String)("Textfield '" + identifier + "' is enabled."), (boolean)this.createOperator(identifier).isEnabled());
    }

    private TextComponentOperator createOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }
}

