/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.togglebutton;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.button.AbstractButtonOperator;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.togglebutton.ToggleButtonOperatorFactory;

@RobotKeywords
public class ToggleButtonKeywords {
    public static final String __PARANAMER_DATA = "\npushToggleButton java.lang.String identifier \n\ntoggleButtonShouldBeSelected java.lang.String identifier \n\ntoggleButtonShouldNotBeSelected java.lang.String identifier \n";
    private OperatorFactory<AbstractButtonOperator> operatorFactory = new ToggleButtonOperatorFactory();

    @RobotKeyword(value="Fails if togglebutton is not selected.\n\nExample:\n| Toggle Button Should Be Selected | _My Toggle Button_ |\n")
    public void toggleButtonShouldBeSelected(String identifier) {
        boolean isSelected = this.createOperator(identifier).isSelected();
        Assert.assertTrue((String)("Toggle Button '" + identifier + "' is not selected."), (boolean)isSelected);
    }

    @RobotKeyword(value="Fails if togglebutton is selected.\n\nExample:\n| Toggle Button Should Not Be Selected | _My Toggle Button_ |\n")
    public void toggleButtonShouldNotBeSelected(String identifier) {
        boolean isSelected = this.createOperator(identifier).isSelected();
        Assert.assertFalse((String)("Toggle Button '" + identifier + "' is selected."), (boolean)isSelected);
    }

    @RobotKeyword(value="Uses current context to search for a button and when found, pushes it.\n\nExample:\n| Push Toggle Button | _Activated_ |\n")
    public void pushToggleButton(String identifier) {
        this.createOperator(identifier).push();
    }

    private AbstractButtonOperator createOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }
}

