/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import java.util.Collection;
import junit.framework.Assert;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.tree.TreeOperator;
import org.robotframework.swing.tree.TreeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RobotKeywords
public class TreeNodeKeywords
extends TreeSupport {
    public static final String __PARANAMER_DATA = "\ngetTreeNodeCount java.lang.String identifier \n\ngetTreeNodeIndex java.lang.String,java.lang.String identifier,nodePath \n\ngetTreeNodeLabel java.lang.String,java.lang.String identifier,nodeIndex \n\ngetTreeNodeChildNames java.lang.String,java.lang.String identifier,nodeIdentifier \n\nclearTreeSelection java.lang.String identifier \n\nclickOnTreeNode java.lang.String,java.lang.String,java.lang.String[] identifier,nodeIdentifier,clickCount \n\ncollapseTreeNode java.lang.String,java.lang.String identifier,nodeIdentifier \n\nexpandTreeNode java.lang.String,java.lang.String identifier,nodeIdentifier \n\nselectTreeNode java.lang.String,java.lang.String,java.lang.String[] identifier,nodeIdentifier,additionalNodeIdentifiers \n\ntreeNodeShouldBeCollapsed java.lang.String,java.lang.String identifier,nodeIdentifier \n\ntreeNodeShouldBeExpanded java.lang.String,java.lang.String identifier,nodeIdentifier \n\ntreeNodeShouldBeLeaf java.lang.String,java.lang.String identifier,nodeIdentifier \n\ntreeNodeShouldNotBeLeaf java.lang.String,java.lang.String identifier,nodeIdentifier \n\nunselectTreeNode java.lang.String,java.lang.String identifier,nodeIdentifier \n";

    @RobotKeyword(value="Clears selections from a tree.\n\nExample:\n| Clear Tree Selection | _myTree_ |\n")
    public void clearTreeSelection(String identifier) {
        this.createTreeOperator(identifier).clearSelection();
    }

    @RobotKeyword(value="Collapses a node in a tree.\n\nExamples:\n| Collapse Tree Node | _myTree_ | _Root|Folder_ |\n| Collapse Tree Node | _myTree_ | _3_ |\n")
    public void collapseTreeNode(String identifier, String nodeIdentifier) {
        this.createTreeOperator(identifier).collapse(nodeIdentifier);
    }

    @RobotKeyword(value="Expands a node in a tree.\n\nExamples:\n| Expand Tree Node | _myTree_ | _Root|Folder_ |\n| Expand Tree Node | _myTree_ | _3_ |\n")
    public void expandTreeNode(String identifier, String nodeIdentifier) {
        this.createTreeOperator(identifier).expand(nodeIdentifier);
    }

    @RobotKeyword(value="Sets a node as selected in a tree.\nDoes not clear earlier selections.\nIf several nodes have the same path then *only the first* of those nodes is selected.\n\nExample:\n| Select Tree Node | _myTree_ | _Root|Folder_ |\nAny number of node identifiers can be provided to select multiple nodes at once:\n| Select Tree Node | _myTree_ | _Root|Folder_ | _Root|Folder2_ | _Root|Folder3_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier", "*additionalNodeIdentifiers"})
    public void selectTreeNode(String identifier, String nodeIdentifier, String[] additionalNodeIdentifiers) {
        TreeOperator treeOperator = this.createTreeOperator(identifier);
        treeOperator.addSelection(nodeIdentifier);
        for (String node : additionalNodeIdentifiers) {
            treeOperator.addSelection(node);
        }
    }

    @RobotKeyword(value="Clicks on a tree node.\n\nExamples:\n| Click On Tree Node | _myTree_ | _Root|Folder_ |\n| Click On Tree Node | _myTree_ | _0_      | \n\nAn optional _click count_ parameter can be provided for example if a double click is required.\nDefault click count is one:\n| Click On Tree Node | _myTree_ | _Root|Folder_ | _2_ | # doubleclicks on node |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier", "*clickCount"})
    public void clickOnTreeNode(String identifier, String nodeIdentifier, String[] clickCount) {
        this.createTreeOperator(identifier).clickOnNode(nodeIdentifier, this.extractIntArgument(clickCount));
    }

    @RobotKeyword(value="Fails if the tree node is collapsed.\n\nExample:\n| Tree Node Should Be Expanded | _myTree_ | _Root|Folder_ |\n")
    public void treeNodeShouldBeExpanded(String identifier, String nodeIdentifier) {
        boolean isExpanded = this.createTreeOperator(identifier).isExpanded(nodeIdentifier);
        Assert.assertTrue((String)("Tree node '" + nodeIdentifier + "' is not expanded."), (boolean)isExpanded);
    }

    @RobotKeyword(value="Fails if the tree node is expanded.\n\nExample:\n| Tree Node Should Be Collapsed | _myTree_ | _Root|Folder_ |\n")
    public void treeNodeShouldBeCollapsed(String identifier, String nodeIdentifier) {
        boolean isCollapsed = this.createTreeOperator(identifier).isCollapsed(nodeIdentifier);
        Assert.assertTrue((String)("Tree node '" + nodeIdentifier + "' is not collapsed."), (boolean)isCollapsed);
    }

    @RobotKeyword(value="Sets a tree node as unselected.\n\nExample:\n| Unselect Tree Node | _myTree_ | _Root|Folder_ |\n")
    public void unselectTreeNode(String identifier, String nodeIdentifier) {
        this.createTreeOperator(identifier).removeSelection(nodeIdentifier);
    }

    @RobotKeyword(value="Fails if the node has child nodes.\nAssumes current context is a tree.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`\n\nExample:\n| Tree Node Should Be Leaf | _myTree_ | _Root|Folder_ |\n")
    public void treeNodeShouldBeLeaf(String identifier, String nodeIdentifier) {
        boolean isLeaf = this.createTreeOperator(identifier).isLeaf(nodeIdentifier);
        Assert.assertTrue((String)("Tree node '" + nodeIdentifier + "' is not leaf."), (boolean)isLeaf);
    }

    @RobotKeyword(value="Fails if the node doesn't have child nodes.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`\n\nExample:\n| Tree Node Should Not Be Leaf | _myTree_ | _Root|Folder_ |\n")
    public void treeNodeShouldNotBeLeaf(String identifier, String nodeIdentifier) {
        boolean isLeaf = this.createTreeOperator(identifier).isLeaf(nodeIdentifier);
        Assert.assertFalse((String)("Tree node '" + nodeIdentifier + "' is leaf."), (boolean)isLeaf);
    }

    @RobotKeyword(value="Returns the count of all visible nodes.\n\nExample:\n| ${nodeCount}= | Get Tree Node Count | _myTree_ |\n| Should Be Equal As Integers | _3_ | _${nodeCount}_ |\n")
    public int getTreeNodeCount(String identifier) {
        return this.createTreeOperator(identifier).getRowCount();
    }

    @RobotKeyword(value="Returns the node name.\nNodeIndex must be a number and it is counted from visible nodes (index starts from 0).\n\nExample:\n| ${nodeLabel}= | Get Tree Node Label | _myTree_ | _3_ |\n| Should Be Equal | _Element1_ | _${nodeLabel}_ |\n")
    public String getTreeNodeLabel(String identifier, String nodeIndex) {
        TreeOperator treeOperator = this.createTreeOperator(identifier);
        return treeOperator.getTreeNodeLabel(this.asIndex(nodeIndex));
    }

    @RobotKeyword(value="Returns the node index.\nNodePath must be a string of form _path|to|node_.\n\nExample:\n| ${nodeIndex}= | Get Tree Node Index | _myTree_ | _Root|Folder|ElementX_ |\n| Should Be Equal As Integers | _4_ | _${nodeIndex}_ |\n")
    public int getTreeNodeIndex(String identifier, String nodePath) {
        return this.createTreeOperator(identifier).getTreeNodeIndex(nodePath);
    }

    @RobotKeyword(value="Returns a list with all the child node names of the specified node.\n\nExample:\n| ${expectedElements}= | Create List | _someElement_ | _otherElement_ | |\n| ${actualElements}=   | Get Tree Node Child Names | _myTree_ | _Element Folder_ | |\n| Lists Should Be Equal | _${expectedElements}_ | _${actualElements}_ | # This keyword comes from Collections library |\n")
    public Collection<String> getTreeNodeChildNames(String identifier, String nodeIdentifier) {
        return this.createTreeOperator(identifier).getTreeNodeChildNames(nodeIdentifier);
    }
}

