/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.window;

import java.awt.Component;
import java.awt.Window;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.AbstractContextVerifier;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.window.FrameOperator;
import org.robotframework.swing.window.FrameOperatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RobotKeywords
public class WindowKeywords
extends AbstractContextVerifier {
    public static final String __PARANAMER_DATA = "\n<init> \n\ngetSelectedWindowTitle \n\ncloseWindow java.lang.String identifier \n\nselectMainWindow \n\nselectWindow java.lang.String identifier \n";
    private IdentifierParsingOperatorFactory<FrameOperator> operatorFactory = new FrameOperatorFactory();

    public WindowKeywords() {
        super("To use this keyword you must first select a window as context using the 'Select Window'-keyword.");
    }

    @RobotKeyword(value="Selects the window that was opened first as current context.\n\nExample:\n| Select Main Window |\n")
    public void selectMainWindow() {
        this.setContext(this.operatorFactory.createOperatorByIndex(0));
    }

    @RobotKeyword(value="Selects a window was as current context.\n\nExample:\n| Select Window | _Help_ |\n")
    public void selectWindow(String identifier) {
        this.setContext(this.operatorFactory.createOperator(identifier));
    }

    @RobotKeyword(value="Closes a window.\n\nExample:\n| Close Window | _Help_ |\n")
    public void closeWindow(String identifier) {
        FrameOperator frameOperator = this.operatorFactory.createOperator(identifier);
        frameOperator.setDefaultCloseOperation(2);
        frameOperator.close();
    }

    @RobotKeyword(value="Returns the title of the selected window.\nAssumes current context is window.\n\nExample:\n| ${title}=     | Get Selected Window Title |            |\n| Should Be Equal | _Help Contents_           | _${title}_ |\n")
    public String getSelectedWindowTitle() {
        return this.frameOperator().getTitle();
    }

    @Override
    protected Class<? extends Component>[] getExpectedClasses() {
        return new Class[]{Window.class};
    }

    private void setContext(FrameOperator frameOperator) {
        Context.setContext(frameOperator);
    }

    private FrameOperator frameOperator() {
        this.verifyContext();
        return (FrameOperator)Context.getContext();
    }
}

