/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.table;

import java.awt.Component;
import java.awt.Point;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.Operator;
import org.robotframework.swing.common.IdentifierSupport;
import org.robotframework.swing.comparator.EqualsStringComparator;
import org.robotframework.swing.table.ColumnIndexTableCellChooser;
import org.robotframework.swing.table.ColumnNameTableCellChooser;
import org.robotframework.swing.table.InvalidCellException;
import org.robotframework.swing.table.TableOperator;

public class DefaultTableOperator
extends IdentifierSupport
implements TableOperator {
    public static final String __PARANAMER_DATA = "\n<init> org.netbeans.jemmy.operators.JTableOperator jTableOperator \n\nisCellSelected java.lang.String,java.lang.String row,columnIdentifier \n\nfindCellRow java.lang.String text \n\ngetColumnCount \n\ngetRowCount \n\ngetSource \n\ngetCellValue java.lang.String,java.lang.String row,columnIdentifier \n\ngetSelectedCellValue \n\ncallPopupOnCell java.lang.String,java.lang.String row,columnIdentifier \n\nclearCell java.lang.String,java.lang.String row,columnIdentifier \n\nclearSelection \n\nselectCell java.lang.String,java.lang.String row,columnIdentifier \n\nsetCellValue java.lang.Object,java.lang.String,java.lang.String newValue,row,columnIdentifier \n\ntypeIntoCell java.lang.Object,java.lang.String,java.lang.String newValue,row,columnIdentifier \n";
    private final JTableOperator jTableOperator;

    public DefaultTableOperator(JTableOperator jTableOperator) {
        this.jTableOperator = jTableOperator;
        this.jTableOperator.setComparator((Operator.StringComparator)new EqualsStringComparator());
    }

    public Object getCellValue(String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        return this.jTableOperator.getValueAt(coordinates.y, coordinates.x);
    }

    public boolean isCellSelected(String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        return this.jTableOperator.isCellSelected(coordinates.y, coordinates.x);
    }

    public void selectCell(String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        this.jTableOperator.selectCell(coordinates.y, coordinates.x);
    }

    public void setCellValue(Object newValue, String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        this.jTableOperator.setValueAt(newValue, coordinates.y, coordinates.x);
    }

    public void typeIntoCell(Object newValue, String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        this.jTableOperator.changeCellObject(coordinates.y, coordinates.x, newValue);
    }

    public void clearCell(String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        this.jTableOperator.changeCellObject(coordinates.y, coordinates.x, (Object)"");
    }

    public void clearSelection() {
        this.jTableOperator.clearSelection();
    }

    public int getColumnCount() {
        return this.jTableOperator.getColumnCount();
    }

    public int getRowCount() {
        return this.jTableOperator.getRowCount();
    }

    public int findCellRow(String text) {
        return this.jTableOperator.findCellRow(text);
    }

    public Object getSelectedCellValue() {
        int selectedRow = this.jTableOperator.getSelectedRow();
        int selectedColumn = this.jTableOperator.getSelectedColumn();
        return this.jTableOperator.getValueAt(selectedRow, selectedColumn);
    }

    public JPopupMenuOperator callPopupOnCell(String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        return new JPopupMenuOperator(this.jTableOperator.callPopupOnCell(coordinates.y, coordinates.x));
    }

    public Component getSource() {
        return this.jTableOperator.getSource();
    }

    protected Point findCell(String row, String columnIdentifier) {
        JTableOperator.TableCellChooser cellChooser = this.createCellChooser(row, columnIdentifier);
        Point cell = this.jTableOperator.findCell(cellChooser);
        if (this.cellIsInvalid(cell)) {
            throw new InvalidCellException(row, columnIdentifier);
        }
        return cell;
    }

    protected boolean cellIsInvalid(Point cell) {
        return cell.x < 0 || cell.y < 0;
    }

    protected JTableOperator.TableCellChooser createCellChooser(String row, String columnIdentifier) {
        if (this.isIndex(columnIdentifier)) {
            return new ColumnIndexTableCellChooser(row, columnIdentifier);
        }
        return new ColumnNameTableCellChooser(row, columnIdentifier);
    }
}

