/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.tree;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.robotframework.javalib.util.ArrayUtil;
import org.robotframework.swing.tree.TreeInfo;
import org.springframework.util.ObjectUtils;

public class TreeNodes {
    public static final String __PARANAMER_DATA = "\n<init> org.robotframework.swing.tree.TreeInfo treeInfo \n\nextractTreePath java.lang.String path \n";
    private TreeInfo treeInfo;

    public TreeNodes(TreeInfo treeInfo) {
        this.treeInfo = treeInfo;
    }

    public TreePath extractTreePath(String path) {
        return this.buildTreePath(this.parse(path));
    }

    private String[] parse(String path) {
        return this.removeRootIfNecessary(path.split("\\|"));
    }

    private String[] removeRootIfNecessary(String[] nodeNames) {
        String rootAsString = this.treeInfo.getNodeText(this.treeInfo.getRoot());
        if (this.treeInfo.rootIsVisible() && nodeNames.length > 0 && nodeNames[0].equals(rootAsString)) {
            return (String[])ArrayUtil.copyOfRange((Object[])nodeNames, (int)1, (int)nodeNames.length);
        }
        return nodeNames;
    }

    private TreePath buildTreePath(String[] nodeNames) {
        TreeNode root = this.treeInfo.getRoot();
        TreePath treePathToNode = new TreePath(root);
        Enumeration<? extends TreeNode> currentLevelChildren = root.children();
        for (String nodeName : nodeNames) {
            boolean foundMatch = false;
            while (currentLevelChildren.hasMoreElements()) {
                TreeNode currentNode = currentLevelChildren.nextElement();
                if (!ObjectUtils.nullSafeEquals((Object)this.treeInfo.getNodeText(currentNode), (Object)nodeName)) continue;
                currentLevelChildren = currentNode.children();
                treePathToNode = treePathToNode.pathByAddingChild(currentNode);
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return null;
        }
        return treePathToNode;
    }
}

