/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.tree;

import java.awt.Component;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.robotframework.swing.operator.ComponentWrapper;
import org.robotframework.swing.popup.DefaultPopupCaller;
import org.robotframework.swing.popup.PopupCaller;
import org.robotframework.swing.tree.NodeTextExtractor;
import org.robotframework.swing.tree.TreePathFactory;
import org.robotframework.swing.tree.TreePathWaitable;
import org.robotframework.swing.tree.TreePopupMenuOperatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeOperator
implements ComponentWrapper {
    public static final String __PARANAMER_DATA = "\n<init> org.netbeans.jemmy.operators.ContainerOperator,int containerOperator,index \n\n<init> org.netbeans.jemmy.operators.ContainerOperator,org.netbeans.jemmy.ComponentChooser containerOperator,componentChooser \n\n<init> org.netbeans.jemmy.operators.JTreeOperator treeOperator \n\nisCollapsed java.lang.String nodeIdentifier \n\nisExpanded java.lang.String nodeIdentifier \n\nisLeaf java.lang.String nodeIdentifier \n\nisPathSelected java.lang.String nodeIdentifier \n\nisVisible java.lang.String nodeIdentifier \n\ngetRowCount \n\ngetTreeNodeIndex java.lang.String nodePath \n\ngetSource \n\ngetTreeNodeLabel int index \n\ngetTreeNodeChildNames java.lang.String nodeIdentifier \n\ncallPopupOnPath javax.swing.tree.TreePath treePath \n\ncallPopupOnPaths javax.swing.tree.TreePath[] treePaths \n\ncallPopupOnRow int row \n\nfindPath java.lang.String treePath \n\ngetPathForRow int i \n\ngetSelectionPaths \n\ncreatePopupOperator java.lang.String nodeIdentifier \n\ncreatePopupOperatorOnSelectedNodes \n\naddSelection java.lang.String nodeIdentifier \n\nclearSelection \n\nclickOnNode java.lang.String,int nodeIdentifier,clickCount \n\ncollapse java.lang.String nodeIdentifier \n\nexpand java.lang.String nodeIdentifier \n\nremoveSelection java.lang.String nodeIdentifier \n";
    protected PopupCaller<ComponentOperator> popupCaller = new DefaultPopupCaller();
    protected TreePathFactory treePathFactory = new TreePathFactory(this);
    protected JTreeOperator jTreeOperator;

    public TreeOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this.jTreeOperator = new JTreeOperator(containerOperator, componentChooser);
    }

    public TreeOperator(ContainerOperator containerOperator, int index) {
        this.jTreeOperator = new JTreeOperator(containerOperator, index);
    }

    public TreeOperator(JTreeOperator treeOperator) {
        this.jTreeOperator = treeOperator;
    }

    public JPopupMenu callPopupOnRow(int row) {
        this.jTreeOperator.selectRow(row);
        this.jTreeOperator.scrollToRow(row);
        Point pointToClick = this.jTreeOperator.getPointToClick(row);
        return this.popupCaller.callPopupOnComponent((ComponentOperator)this.jTreeOperator, pointToClick);
    }

    public TreePath findPath(String treePath) {
        try {
            return (TreePath)this.createTreeWaiter(treePath).waitAction(null);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void expand(String nodeIdentifier) {
        this.jTreeOperator.expandPath(this.createTreePath(nodeIdentifier));
    }

    public void collapse(String nodeIdentifier) {
        this.jTreeOperator.collapsePath(this.createTreePath(nodeIdentifier));
    }

    public void addSelection(String nodeIdentifier) {
        this.jTreeOperator.addSelectionPath(this.createTreePath(nodeIdentifier));
    }

    public void removeSelection(String nodeIdentifier) {
        this.jTreeOperator.removeSelectionPath(this.createTreePath(nodeIdentifier));
    }

    public boolean isExpanded(String nodeIdentifier) {
        return this.jTreeOperator.isExpanded(this.createTreePath(nodeIdentifier));
    }

    public boolean isCollapsed(String nodeIdentifier) {
        return this.jTreeOperator.isCollapsed(this.createTreePath(nodeIdentifier));
    }

    public boolean isLeaf(String nodeIdentifier) {
        TreeNode lastPathComponent = (TreeNode)this.createTreePath(nodeIdentifier).getLastPathComponent();
        return lastPathComponent.isLeaf();
    }

    public boolean isPathSelected(String nodeIdentifier) {
        return this.jTreeOperator.isPathSelected(this.createTreePath(nodeIdentifier));
    }

    public boolean isVisible(String nodeIdentifier) {
        return this.jTreeOperator.isVisible(this.createTreePath(nodeIdentifier));
    }

    public void clickOnNode(String nodeIdentifier, int clickCount) {
        this.jTreeOperator.clickOnPath(this.createTreePath(nodeIdentifier), clickCount);
    }

    public JPopupMenuOperator createPopupOperator(String nodeIdentifier) {
        return (JPopupMenuOperator)this.createPopupFactory().createOperator(nodeIdentifier);
    }

    public JPopupMenuOperator createPopupOperatorOnSelectedNodes() {
        return this.createPopupFactory().createOperatorBySelection();
    }

    public String getTreeNodeLabel(int index) {
        TreePath pathForRow = this.jTreeOperator.getPathForRow(index);
        return pathForRow.getLastPathComponent().toString();
    }

    public int getTreeNodeIndex(String nodePath) {
        return this.jTreeOperator.getRowForPath(this.findPath(nodePath));
    }

    @Override
    public Component getSource() {
        return this.jTreeOperator.getSource();
    }

    public TreePath getPathForRow(int i) {
        return this.jTreeOperator.getPathForRow(i);
    }

    public int getRowCount() {
        return this.jTreeOperator.getRowCount();
    }

    public void clearSelection() {
        this.jTreeOperator.clearSelection();
    }

    public JPopupMenu callPopupOnPath(TreePath treePath) {
        return this.jTreeOperator.callPopupOnPath(treePath);
    }

    public JPopupMenu callPopupOnPaths(TreePath[] treePaths) {
        return this.jTreeOperator.callPopupOnPaths(treePaths);
    }

    public TreePath[] getSelectionPaths() {
        return this.jTreeOperator.getSelectionPaths();
    }

    public Collection<String> getTreeNodeChildNames(String nodeIdentifier) {
        final TreePath treePath = this.createTreePath(nodeIdentifier);
        return CollectionUtils.collect(this.getChildPaths(treePath), (Transformer)new Transformer(){

            public Object transform(Object input) {
                Object node = ((TreePath)input).getLastPathComponent();
                return new NodeTextExtractor((JTree)TreeOperator.this.getSource()).getText(node, treePath);
            }
        });
    }

    private List<TreePath> getChildPaths(TreePath treePath) {
        return Arrays.asList(this.jTreeOperator.getChildPaths(treePath));
    }

    protected TreePopupMenuOperatorFactory createPopupFactory() {
        return new TreePopupMenuOperatorFactory(this);
    }

    protected TreePath createTreePath(String nodeIdentifier) {
        return this.treePathFactory.createTreePath(nodeIdentifier);
    }

    protected Waiter createTreeWaiter(String treePath) {
        Waiter waiter = new Waiter((Waitable)new TreePathWaitable((JTree)this.getSource(), treePath));
        Timeouts nextNodeTimeout = this.copyTimeout("JTreeOperator.WaitNextNodeTimeout");
        waiter.setTimeouts(nextNodeTimeout);
        return waiter;
    }

    protected Timeouts copyTimeout(String timeout) {
        Timeouts times = this.jTreeOperator.getTimeouts().cloneThis();
        times.setTimeout("Waiter.WaitingTime", this.jTreeOperator.getTimeouts().getTimeout(timeout));
        return times;
    }
}

