/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.tree;

import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.robotframework.swing.common.SmoothInvoker;
import org.robotframework.swing.tree.NodeTextExtractor;
import org.robotframework.swing.tree.TreeInfo;
import org.robotframework.swing.tree.TreeNodes;

public class TreePathWaitable
implements Waitable {
    public static final String __PARANAMER_DATA = "\n<init> javax.swing.JTree,java.lang.String tree,path \n\nactionProduced java.lang.Object arg0 \n\ngetDescription \n";
    private final String path;
    private final JTree tree;

    public TreePathWaitable(JTree tree, String path) {
        this.tree = tree;
        this.path = path;
    }

    public Object actionProduced(Object arg0) {
        TreeInfo treeInfo = this.createTreeInfo();
        TreeNodes treeNodes = new TreeNodes(treeInfo);
        return treeNodes.extractTreePath(this.path);
    }

    public String getDescription() {
        return "Tree path";
    }

    private TreeInfo createTreeInfo() {
        return new TreeInfo(){

            public String getNodeText(Object node) {
                return TreePathWaitable.this.extractTextSmoothly(node);
            }

            public TreeNode getRoot() {
                return TreePathWaitable.this.getRootSmoothly();
            }

            public boolean rootIsVisible() {
                return new JTreeOperator(TreePathWaitable.this.tree).isRootVisible();
            }
        };
    }

    private String extractTextSmoothly(Object node) {
        return new NodeTextExtractor(this.tree).getText(node, this.path);
    }

    private TreeNode getRootSmoothly() {
        return (TreeNode)new SmoothInvoker<TreeNode>(){

            @Override
            public Object work() {
                return TreePathWaitable.this.tree.getModel().getRoot();
            }
        }.invoke();
    }
}

