/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.editor.FileSystemHelper;
import abbot.finder.TestHierarchy;
import abbot.script.Script;
import java.io.File;

public class EditorContext {
    private String[] _arguments;
    private boolean _embedded;
    private TestHierarchy _hierarchy = null;
    private SecurityManager _securityManager = null;
    private File _newFileTemplate = null;
    private FileSystemHelper _fileSystemHelper = new FileSystemHelper();

    public EditorContext(String[] arguments) {
        this._arguments = arguments;
    }

    public EditorContext() {
        this._arguments = new String[0];
    }

    public String[] getArguments() {
        return (String[])this._arguments.clone();
    }

    public void setArguments(String[] arguments) {
        this._arguments = arguments;
    }

    public boolean isEmbedded() {
        return this._embedded;
    }

    public void setEmbedded(boolean embedded) {
        this._embedded = embedded;
    }

    public TestHierarchy getTestHierarchy() {
        return this._hierarchy;
    }

    public void setTestHierarchy(TestHierarchy hierarchy) {
        if (!this.isEmbedded()) {
            throw new IllegalStateException("Only value when Costello is to be embedded");
        }
        this._hierarchy = hierarchy;
    }

    public void setNewFileTemplate(File newFileTemplate) {
        if (!newFileTemplate.exists()) {
            throw new IllegalArgumentException("File doesn't exist");
        }
        if (!Script.isScript(newFileTemplate)) {
            throw new IllegalArgumentException("File doesn't appears to be a script");
        }
        this._newFileTemplate = newFileTemplate;
    }

    public File getNewFileTemplate() {
        return this._newFileTemplate;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this._securityManager = securityManager;
    }

    public SecurityManager getSecurityManager() {
        return this._securityManager;
    }

    public void setFileSysteHelper(FileSystemHelper helper) {
        this._fileSystemHelper = helper;
    }

    public FileSystemHelper getFileSystemHelper() {
        return this._fileSystemHelper;
    }
}

