/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.editors;

import abbot.Log;
import abbot.editor.editors.StepEditor;
import abbot.i18n.Strings;
import abbot.script.Annotation;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextArea;

public class AnnotationEditor
extends StepEditor {
    private Annotation annotation;
    private JTextArea text;
    private JButton reposition;
    private JCheckBox userDismiss;
    private JComboBox relative;

    public AnnotationEditor(Annotation annotation) {
        super(annotation);
        this.annotation = annotation;
        this.text = this.addTextArea(Strings.get("AnnotationText"), annotation.getText());
        this.relative = this.addComponentSelector(Strings.get("AnchorComponent"), annotation.getRelativeTo(), annotation.getResolver(), true);
        this.reposition = this.addButton(Strings.get("Reposition"));
        this.userDismiss = this.addCheckBox(Strings.get("UserDismiss"), annotation.getUserDismiss());
    }

    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == this.text) {
            this.annotation.setText(this.text.getText());
            this.fireStepChanged();
        } else if (src == this.relative) {
            this.annotation.setRelativeTo((String)this.relative.getSelectedItem());
            this.fireStepChanged();
        } else if (src == this.reposition) {
            try {
                this.annotation.showAnnotation();
                this.fireStepChanged();
            }
            catch (Exception e) {
                Log.warn(e);
            }
        } else if (src == this.userDismiss) {
            this.annotation.setUserDismiss(this.userDismiss.isSelected());
            if (this.annotation.isShowing()) {
                this.annotation.showAnnotation();
            }
            this.fireStepChanged();
        } else {
            super.actionPerformed(ev);
        }
    }
}

