/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.WaitTimedOutError;
import abbot.i18n.Strings;
import abbot.script.Condition;
import abbot.tester.ComponentLocation;
import abbot.tester.JComponentTester;
import abbot.tester.JTableLocation;
import abbot.tester.LocationUnavailableException;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JTable;

public class JTableTester
extends JComponentTester {
    public static String valueToString(JTable table, int row, int col) {
        Object value = table.getValueAt(row, col);
        Component cr = table.getCellRenderer(row, col).getTableCellRendererComponent(table, value, false, false, row, col);
        String string = JTableTester.convertRendererToString(cr);
        return string;
    }

    public void actionSelectCell(Component c, JTableLocation loc) {
        this.actionSelectCell(c, loc, componentDelay);
    }

    public void actionSelectCell(Component c, final JTableLocation loc, int timeout) {
        final JTable table = (JTable)c;
        final JTableLocation.Cell[] found = new JTableLocation.Cell[1];
        try {
            this.wait(new Condition(){

                public boolean test() {
                    try {
                        found[0] = loc.getCell(table);
                        return found[0] != null;
                    }
                    catch (LocationUnavailableException lue) {
                        return false;
                    }
                }

                public String toString() {
                    return Strings.get("tester.Component.show_wait", new Object[]{loc.toString()});
                }
            }, (long)timeout);
        }
        catch (WaitTimedOutError e) {
            throw new LocationUnavailableException(e.getMessage());
        }
        JTableLocation.Cell cell = found[0];
        if (table.isRowSelected(cell.row) && table.isColumnSelected(cell.col) && table.getSelectedRowCount() == 1) {
            return;
        }
        this.actionClick(c, loc);
    }

    public void actionSelectCell(Component c, int row, int col) {
        this.actionSelectCell(c, new JTableLocation(row, col));
    }

    public ComponentLocation parseLocation(String encoded) {
        return new JTableLocation().parse(encoded);
    }

    public ComponentLocation getLocation(Component c, Point p) {
        JTable table = (JTable)c;
        int row = table.rowAtPoint(p);
        int col = table.columnAtPoint(p);
        if (row != -1 && col != -1) {
            String value = JTableTester.valueToString(table, row, col);
            if (value != null) {
                return new JTableLocation(value);
            }
            return new JTableLocation(row, col);
        }
        return new JTableLocation(p);
    }
}

