/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.component;

import junit.framework.Assert;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.keyword.component.ComponentOperatorFactory;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class ComponentKeywords {
    public static final String __PARANAMER_DATA = "\ncomponentShouldExist java.lang.String identifier \n\ncomponentShouldNotExist java.lang.String identifier \n";
    private IdentifierParsingOperatorFactory<ComponentOperator> operatorFactory = new ComponentOperatorFactory();
    private IComponentConditionResolver componentExistenceResolver = new ComponentExistenceResolver(this.operatorFactory);

    @RobotKeyword(value="Fails if component exists within current context.\nYou might want to set the waiting timeout with the keyword _'Set Jemmy Timeout'_\n\nExample:\n| Component Should Not Exist | _myPanel_ |\n")
    public void componentShouldNotExist(String identifier) {
        Assert.assertFalse((String)("Component '" + identifier + "' exists"), (boolean)this.componentExistenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Fails if component does not exist within current context.\nYou might want to set the waiting timeout with the keyword _'Set Jemmy Timeout'_\n\nExample:\n| Component Should Not Exist | _myPanel_ |\n")
    public void componentShouldExist(String identifier) {
        Assert.assertTrue((String)("Component '" + identifier + "' does not exist"), (boolean)this.componentExistenceResolver.satisfiesCondition(identifier));
    }
}

