/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.list;

import org.netbeans.jemmy.operators.JListOperator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.arguments.VoidIdentifierHandler;
import org.robotframework.swing.context.DefaultContextVerifier;
import org.robotframework.swing.context.IContextVerifier;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.keyword.list.ListOperatorFactory;
import org.springframework.util.ObjectUtils;

@RobotKeywords
public class ListKeywords {
    public static final String __PARANAMER_DATA = "\ngetListItemCount java.lang.String identifier \n\ngetSelectedValueFromList java.lang.String identifier \n\nclearSelectionFromList java.lang.String identifier \n\nselectFromList java.lang.String,java.lang.String identifier,listItemIdentifier \n";
    private OperatorFactory<JListOperator> operatorFactory = new ListOperatorFactory();
    private IContextVerifier contextVerifier = new DefaultContextVerifier();

    @RobotKeyword(value="Clears selection from list.\n\nExample:\n| Clear Selection From List | _myList_ |\n")
    public void clearSelectionFromList(String identifier) {
        this.contextVerifier.verifyContext();
        this.operatorFactory.createOperator(identifier).clearSelection();
    }

    @RobotKeyword(value="Selects an item from the list.\n\nExamples:\n| Select From List | _myList_ | _myItem_ | # selects 'myItem'                   |\n| Select From List | _myList_ | _0_      | # selects the first item in the list |\n")
    public void selectFromList(String identifier, String listItemIdentifier) {
        this.contextVerifier.verifyContext();
        JListOperator listOperator = this.operatorFactory.createOperator(identifier);
        new ListSelector(listOperator).parseArgument(listItemIdentifier);
    }

    @RobotKeyword(value="Returns the item that's currently selected in the list.\n\nExample:\n| ${listItem}=    | Get Selected Value From List | _myList_      |\n| Should Be Equal | _Expected Item_              | _${listItem}_ |\n")
    public Object getSelectedValueFromList(String identifier) {
        this.contextVerifier.verifyContext();
        return this.operatorFactory.createOperator(identifier).getSelectedValue();
    }

    @RobotKeyword(value="Returns the number of items contained in list.\n\nExample:\n| ${listItemCount}=    | Get List Item Count | _myList_      |\n| Should Be Equal As Integers | _2_ | _${listItemCount}_ |\n")
    public int getListItemCount(String identifier) {
        this.contextVerifier.verifyContext();
        return this.operatorFactory.createOperator(identifier).getModel().getSize();
    }

    private static class ListSelector
    extends VoidIdentifierHandler {
        public static final String __PARANAMER_DATA = "\n<init> org.netbeans.jemmy.operators.JListOperator listOperator \n";
        private final JListOperator listOperator;

        public ListSelector(JListOperator listOperator) {
            this.listOperator = listOperator;
        }

        protected void handleIndexArgument(int index) {
            this.listOperator.selectItem(index);
        }

        protected void handleNameArgument(final String name) {
            JListOperator.ListItemChooser itemChooser = new JListOperator.ListItemChooser(){

                public boolean checkItem(JListOperator listOperator, int index) {
                    String item = listOperator.getModel().getElementAt(index).toString();
                    return ObjectUtils.nullSafeEquals((Object)name, (Object)item);
                }

                public String getDescription() {
                    return name;
                }
            };
            int itemIndex = this.listOperator.findItemIndex(itemChooser);
            this.listOperator.selectItem(itemIndex);
        }
    }
}

