/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.menu;

import junit.framework.Assert;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.arguments.ArgumentParser;
import org.robotframework.swing.keyword.menu.MenuSupport;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class MenuKeywords
extends MenuSupport {
    public static final String __PARANAMER_DATA = "\nmainMenuItemShouldExist java.lang.String menuPath \n\nmenuItemShouldBeDisabled java.lang.String menuPath \n\nmenuItemShouldBeEnabled java.lang.String menuPath \n\nmenuItemShouldNotBeEnabled java.lang.String menuPath \n\nselectFromMenu java.lang.String menuPath \n\nselectFromMenuAndWait java.lang.String menuPath \n";
    private EventTool eventTool = new EventTool();

    @RobotKeyword(value="Selects an item from the menu of the currently selected window.\n\nExample:\n| Select Window    | _My Application_           |\n| Select From Menu | _Tools|Testing|MyTestTool_ |\n")
    public void selectFromMenu(String menuPath) {
        this.showMenuItem(menuPath).pushNoBlock();
    }

    @RobotKeyword(value="Selects an item from the menu of the currently selected window and waits for action to finish.\nThis keyword will not work, for example, if the menu item opens a dialog.\n\nExample:\n| Select Window             | _My Application_           |\n| Select From Menu And Wait | _Tools|Testing|MyTestTool_ |\n")
    public void selectFromMenuAndWait(String menuPath) {
        this.showMenuItem(menuPath).push();
    }

    @RobotKeyword(value="Fails if menu item doesn't exist in the first opened window.\n\nExample:\n| Main Menu Item Should Exist | _Tools|Testing|Test Tool_ |\n")
    public void mainMenuItemShouldExist(String menuPath) {
        IComponentConditionResolver existenceResolver = this.createMenuItemExistenceResolver();
        Assert.assertTrue((String)("Menu item '" + menuPath + "' does not exist."), (boolean)existenceResolver.satisfiesCondition(menuPath));
    }

    @RobotKeyword(value="Searches for an menu item from the menu of the currently selected window and fails if it is disabled.\n\nExample:\n| Select Window               | _My Application_           |\n| Menu Item Should Be Enabled | _Tools|Testing|MyTestTool_ |\n")
    public void menuItemShouldBeEnabled(String menuPath) {
        Assert.assertTrue((String)("Menu item '" + menuPath + "' is disabled."), (boolean)this.menuItemIsEnabled(menuPath));
    }

    @RobotKeyword(value="Searches for an menu item from the menu of the currently selected window and fails if it is enabled.\n\nExample:\n| Select Window                   | _My Application_           |\n| Menu Item Should Not Be Enabled | _Tools|Testing|MyTestTool_ |\n")
    public void menuItemShouldNotBeEnabled(String menuPath) {
        Assert.assertFalse((String)("Menu item '" + menuPath + "' is enabled."), (boolean)this.menuItemIsEnabled(menuPath));
    }

    @RobotKeyword(value="Alias for _'Menu Item Should Not Be Enabled'_\n")
    public void menuItemShouldBeDisabled(String menuPath) {
        this.menuItemShouldNotBeEnabled(menuPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean menuItemIsEnabled(String menuPath) {
        try {
            boolean bl = this.showMenuItem(menuPath).isEnabled();
            return bl;
        }
        finally {
            this.closeMenu();
        }
    }

    private void closeMenu() {
        this.menubarOperator().pressMouse();
    }

    JMenuItemOperator showMenuItem(String path) {
        JMenuItemOperator menuItemOperator = this.menubarOperator().showMenuItem(path);
        this.eventTool.waitNoEvent(200L);
        menuItemOperator.grabFocus();
        this.eventTool.waitNoEvent(200L);
        return menuItemOperator;
    }

    IComponentConditionResolver createMenuItemExistenceResolver() {
        ArgumentParser<JMenuItemOperator> menuItemOperatorFactory = new ArgumentParser<JMenuItemOperator>(){

            @Override
            public JMenuItemOperator parseArgument(String menuPath) {
                return MenuKeywords.this.menubarOperator().showMenuItem(menuPath);
            }
        };
        return new ComponentExistenceResolver(menuItemOperatorFactory);
    }
}

