/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.table;

import junit.framework.Assert;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.context.IContextVerifier;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.keyword.table.EnhancedTableOperator;
import org.robotframework.swing.keyword.table.TableContextVerifier;
import org.robotframework.swing.keyword.table.TableOperatorFactory;

@RobotKeywords
public class TableKeywords {
    public static final String __PARANAMER_DATA = "\ngetSelectedTableCellValue \n\ngetTableCellValue java.lang.String,java.lang.String row,columnIdentifier \n\nclearTableSelection \n\nselectTable java.lang.String identifier \n\nselectTableCell java.lang.String,java.lang.String row,cellIdentifier \n\ntableCellShouldBeSelected java.lang.String,java.lang.String row,columnIdentifier \n\ntableCellShouldNotBeSelected java.lang.String,java.lang.String row,columnIdentifier \n";
    private OperatorFactory<EnhancedTableOperator> operatorFactory = new TableOperatorFactory();
    private IContextVerifier tableContextVerifier = new TableContextVerifier();

    @RobotKeyword(value="Selects a table as current context.\n\nExample:\n| Select Table | _myTable_ |\n")
    public void selectTable(String identifier) {
        Context.setContext((ContainerOperator)this.operatorFactory.createOperator(identifier));
    }

    @RobotKeyword(value="Selects a cell.\nAssumes current context is a table.\n\nExample:\n| Select Table Cell | _0_ | _2_       | # Selects cell from first row and third column |\n| Select Table Cell | _1_ | _Keyword_ | # Selects cell from second row and column with header 'Keyword' |\n")
    public void selectTableCell(String row, String cellIdentifier) {
        this.tableContextVerifier.verifyContext();
        this.tableOperator().selectCell(row, cellIdentifier);
    }

    @RobotKeyword(value="Clears selection from table.\nAssumes current context is a table\n\nExample:\n| Clear Table Selection |\n")
    public void clearTableSelection() {
        this.tableContextVerifier.verifyContext();
        this.tableOperator().clearSelection();
    }

    @RobotKeyword(value="Fails if given table cell is not selected.\nAssumes current context is a table.\n\nExample:\n| Table Cell Should Be Selected | _0_ | _2_       |\n| Table Cell Should Be Selected | _1_ | _Keyword_ |\n")
    public void tableCellShouldBeSelected(String row, String columnIdentifier) {
        this.tableContextVerifier.verifyContext();
        Assert.assertTrue((String)("Cell '" + row + "', '" + columnIdentifier + "' is not selected."), (boolean)this.tableOperator().isCellSelected(row, columnIdentifier));
    }

    @RobotKeyword(value="Fails if given table cell is selected.\nAssumes current context is a table.\n\nExample:\n| Table Cell Should Be Selected | _0_ | _2_       |\n| Table Cell Should Be Selected | _1_ | _Keyword_ |\n")
    public void tableCellShouldNotBeSelected(String row, String columnIdentifier) {
        this.tableContextVerifier.verifyContext();
        Assert.assertFalse((String)("Cell '" + row + "', '" + columnIdentifier + "' is selected."), (boolean)this.tableOperator().isCellSelected(row, columnIdentifier));
    }

    @RobotKeyword(value="Returns cell's value.\nAssumes current context is a table.\n\nExample:\n| ${cellValue}=   | Get Table Cell Value   | _0_            | _2_ |\n| Should Be Equal | _tuesday_              | _${cellValue}_ |     |\n")
    public Object getTableCellValue(String row, String columnIdentifier) {
        this.tableContextVerifier.verifyContext();
        return this.tableOperator().getValueAt(row, columnIdentifier);
    }

    @RobotKeyword(value="Returns selected cell's value.\nAssumes current context is a table.\n\nExample:\n| ${cellValue}=   | Get Selected Table Cell Value   |              |\n| Should Be Equal | _tuesday_                       | _${cellValue}_ |\n")
    public Object getSelectedTableCellValue() {
        this.tableContextVerifier.verifyContext();
        return this.tableOperator().getValueAt(this.tableOperator().getSelectedColumn(), this.tableOperator().getSelectedRow());
    }

    private EnhancedTableOperator tableOperator() {
        return (EnhancedTableOperator)Context.getContext();
    }
}

