/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.textcomponent;

import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.DefaultContextVerifier;
import org.robotframework.swing.context.IContextVerifier;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.keyword.textcomponent.TextComponentOperatorFactory;

@RobotKeywords
public class TextComponentKeywords {
    public static final String __PARANAMER_DATA = "\ngetTextFieldValue java.lang.String identifier \n\nclearTextField java.lang.String identifier \n\ninsertIntoTextField java.lang.String,java.lang.String identifier,text \n\ntypeIntoTextField java.lang.String,java.lang.String identifier,text \n";
    private OperatorFactory<JTextComponentOperator> operatorFactory = new TextComponentOperatorFactory();
    private IContextVerifier contextVerifier = new DefaultContextVerifier();

    @RobotKeyword(value="Inserts text into a text component.\n\nExample:\n| Insert Into Textfield | _nameTextField_ | _John Doe_ |\n")
    public void insertIntoTextField(String identifier, String text) {
        this.contextVerifier.verifyContext();
        JTextComponentOperator textFieldOperator = this.operatorFactory.createOperator(identifier);
        textFieldOperator.setText(text);
    }

    @RobotKeyword(value="Returns the value of a text component.\n\nExample:\n| ${textFieldValue}= | Get Textfield Value | _nameTextField_       |\n| Should Be Equal    | _John Doe_          | _${textFieldValue}_ |\n")
    public String getTextFieldValue(String identifier) {
        this.contextVerifier.verifyContext();
        return this.operatorFactory.createOperator(identifier).getText();
    }

    @RobotKeyword(value="Types text into a text component.\nSame as _Insert Into Textfield_ but sends real key events when setting text field contents.\nUseful if application expects real keyboard events instead of only setting the text of the textfield.\n\nExample:\n| Type Into Textfield | _nameTextField_ | _John Doe_ |\n")
    public void typeIntoTextField(String identifier, String text) {
        this.contextVerifier.verifyContext();
        this.operatorFactory.createOperator(identifier).typeText(text);
    }

    @RobotKeyword(value="Clears text field contents.\n\nExample:\n| Clear Textfield | _nameTextField_ |\n")
    public void clearTextField(String identifier) {
        this.contextVerifier.verifyContext();
        this.operatorFactory.createOperator(identifier).clearText();
    }
}

