/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.tree.TreeSupport;

@RobotKeywords
public class TreeNodeSelectionKeywords
extends TreeSupport {
    public static final String __PARANAMER_DATA = "\ntreeNodeShouldBeSelected java.lang.String nodeIdentifier \n\ntreeNodeShouldNotBeSelected java.lang.String nodeIdentifier \n";

    @RobotKeyword(value="Fails if the tree node is not selected.\nAssumes current context is a tree.\n\nExample:\n| Tree Node Should Be Selected | _Root|Folder_ |\n")
    public void treeNodeShouldBeSelected(String nodeIdentifier) {
        Assert.assertTrue((String)("Tree node '" + nodeIdentifier + "' is not selected."), (boolean)this.isSelected(nodeIdentifier));
    }

    @RobotKeyword(value="Fails if the tree node is selected.\nAssumes current context is a tree.\n\nExample:\n| Tree Node Should Be Selected | _Root|Folder_ |\n")
    public void treeNodeShouldNotBeSelected(String nodeIdentifier) {
        Assert.assertFalse((String)("Tree node '" + nodeIdentifier + "' is selected."), (boolean)this.isSelected(nodeIdentifier));
    }

    private boolean isSelected(String nodeIdentifier) {
        if (this.isIndex(nodeIdentifier)) {
            return this.treeOperator().isRowSelected(this.asIndex(nodeIdentifier));
        }
        return this.treeOperator().isPathSelected(this.treeOperator().findPath(nodeIdentifier));
    }
}

