/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.tree.TreeSupport;

@RobotKeywords
public class TreeNodeVisibilityKeywords
extends TreeSupport {
    public static final String __PARANAMER_DATA = "\ntreeNodeShouldBeVisible java.lang.String nodePath \n\ntreeNodeShouldNotBeVisible java.lang.String nodePath \n";

    @RobotKeyword(value="Fails if the tree node is not visible.\nAssumes current context is a tree.\n\nExample:\n| Tree Node Should Be Visible | _Root|Folder_ |\n")
    public void treeNodeShouldBeVisible(String nodePath) {
        this.verifyContextAndPath(nodePath);
        Assert.assertTrue((String)("Tree node '" + nodePath + "' is not visible."), (boolean)this.isVisible(nodePath));
    }

    @RobotKeyword(value="Fails if the tree node is visible.\nAssumes current context is a tree.\n\nExample:\n| Tree Node Should Not Be Visible | _Root|Folder_ |\n")
    public void treeNodeShouldNotBeVisible(String nodePath) {
        this.verifyContextAndPath(nodePath);
        Assert.assertFalse((String)("Tree node '" + nodePath + "' is visible."), (boolean)this.isVisible(nodePath));
    }

    private boolean isVisible(String nodePath) {
        return this.treeOperator().isVisible(this.treeOperator().findPath(nodePath));
    }

    private void verifyContextAndPath(String nodePath) {
        this.verifyContext();
        this.verifyPath(nodePath);
    }

    private void verifyPath(String nodePath) {
        if (this.isIndex(nodePath)) {
            throw new IllegalArgumentException("Node's visibility cannot be checked by it's index by it's index");
        }
    }
}

