/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import abbot.tester.ComponentTester;
import javax.swing.JMenuItem;
import junit.framework.Assert;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.IContextVerifier;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.tree.ITreePopupMenuItemFinder;
import org.robotframework.swing.tree.TreeContextVerifier;
import org.robotframework.swing.tree.TreePopupMenuItemFinder;
import org.robotframework.swing.tree.TreePopupMenuOperatorFactory;

@RobotKeywords
public class TreePopupKeywords {
    public static final String __PARANAMER_DATA = "\nselectFromTreeNodePopupMenu java.lang.String,java.lang.String nodeIdentifier,menuPath \n\nselectFromTreeNodePopupMenuInSeparateThread java.lang.String,java.lang.String nodeIdentifier,menuPath \n\ntreeNodePopupMenuItemShouldBeDisabled java.lang.String,java.lang.String nodeIdentifier,menuPath \n\ntreeNodePopupMenuItemShouldBeEnabled java.lang.String,java.lang.String nodeIdentifier,menuPath \n";
    private OperatorFactory<JPopupMenuOperator> operatorFactory = new TreePopupMenuOperatorFactory();
    private IContextVerifier contextVerifier = new TreeContextVerifier();
    private ITreePopupMenuItemFinder treePopupMenuItemFinder = new TreePopupMenuItemFinder();

    @RobotKeyword(value="Selects an item from the tree node's popup menu.\nAssumes current context is a tree.\n\nExamples:\n| Select From Tree Node Popup Menu | _Root|Folder_ | _New Folder_ | ")
    public void selectFromTreeNodePopupMenu(String nodeIdentifier, String menuPath) {
        this.contextVerifier.verifyContext();
        this.operatorFactory.createOperator(nodeIdentifier).pushMenu(menuPath);
    }

    @RobotKeyword(value="Selects an item from the tree node's popup menu and does not wait for a result.\nNeeded if the action starts a process that stays running (e.g. opens a dialog) and the above keyword doesn't return.\nAssumes current context is a tree. Separator for items is '|'.\n\nExamples:\n| Select From Tree Node Popup Menu In Separate Thread | _Root|Folder_ | _New Folder_ | ")
    public void selectFromTreeNodePopupMenuInSeparateThread(String nodeIdentifier, String menuPath) {
        this.contextVerifier.verifyContext();
        this.operatorFactory.createOperator(nodeIdentifier).pushMenuNoBlock(menuPath);
    }

    @RobotKeyword(value="Fails if given popup menu item is disabled.\nAssumes current context is a tree.\n\nExample:\n| Tree Node Popup Menu Item Should Be Enabled | _Root|Folder_ | _New Folder_ |\n| Tree Node Popup Menu Item Should Be Enabled | _1_ | _New Folder_ |\n")
    public void treeNodePopupMenuItemShouldBeEnabled(String nodeIdentifier, String menuPath) {
        this.contextVerifier.verifyContext();
        Assert.assertTrue((String)("Menu item '" + menuPath + "' was disabled"), (boolean)this.menuItemIsEnabled(nodeIdentifier, menuPath));
    }

    @RobotKeyword(value="Fails if given popup menu item is enabled.\nAssumes current context is a tree.\n\nExample:\n| Tree Node Popup Menu Item Should Be Disabled | _Root|Folder_ | _New Folder_ |\n| Tree Node Popup Menu Item Should Be Disabled | _1_ | _New Folder_ |\n")
    public void treeNodePopupMenuItemShouldBeDisabled(String nodeIdentifier, String menuPath) {
        this.contextVerifier.verifyContext();
        Assert.assertFalse((String)("Menu item '" + menuPath + "' was enabled"), (boolean)this.menuItemIsEnabled(nodeIdentifier, menuPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean menuItemIsEnabled(String nodeIdentifier, String menuPath) {
        try {
            boolean bl = this.createPopupMenuItem(nodeIdentifier, menuPath).isEnabled();
            return bl;
        }
        finally {
            this.closePopup();
        }
    }

    private void closePopup() {
        new ComponentTester().actionKeyStroke(27);
    }

    private JMenuItem createPopupMenuItem(String nodeIdentifier, String menuPath) {
        return this.treePopupMenuItemFinder.findMenu(nodeIdentifier, menuPath);
    }
}

