/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.tree;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.springframework.util.ObjectUtils;

public class TreePathFinder {
    public static final String __PARANAMER_DATA = "\n<init> org.netbeans.jemmy.operators.JTreeOperator treeOperator \n\nfindPath java.lang.String path \n";
    private final JTreeOperator treeOperator;

    public TreePathFinder(JTreeOperator treeOperator) {
        this.treeOperator = treeOperator;
    }

    public TreePath findPath(String path) {
        String[] nodeNames = this.treeOperator.parseString(path);
        TreeNode rootNode = (TreeNode)this.treeOperator.getRoot();
        nodeNames = this.getStartingPoint(nodeNames, rootNode);
        TreePath treePath = this.buildTreePath(rootNode, nodeNames);
        return treePath;
    }

    private String[] getStartingPoint(String[] nodeNames, TreeNode rootNode) {
        if (this.treeOperator.isRootVisible() && nodeNames[0].equals(rootNode.toString())) {
            return this.removeRoot(nodeNames);
        }
        return nodeNames;
    }

    private TreePath buildTreePath(TreeNode rootNode, String[] nodeNames) {
        TreePath treePathToNode = new TreePath(rootNode);
        Enumeration<? extends TreeNode> currentLevelChildren = rootNode.children();
        for (int i = 0; i < nodeNames.length; ++i) {
            String nodeName = nodeNames[i];
            boolean foundMatch = false;
            while (currentLevelChildren.hasMoreElements()) {
                TreeNode currentNode = currentLevelChildren.nextElement();
                if (!ObjectUtils.nullSafeEquals((Object)currentNode.toString(), (Object)nodeName)) continue;
                currentLevelChildren = currentNode.children();
                treePathToNode = treePathToNode.pathByAddingChild(currentNode);
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return null;
        }
        return treePathToNode;
    }

    private String[] removeRoot(String[] nodeNames) {
        String[] newArray = new String[nodeNames.length - 1];
        for (int i = 1; i < nodeNames.length; ++i) {
            newArray[i - 1] = nodeNames[i];
        }
        return newArray;
    }
}

