/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.Log;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;

public class OSXAdapter
implements InvocationHandler {
    private static Object APPLICATION;
    private static Map adapters;
    private WeakReference source;
    private Action about;
    private Action prefs;
    private Action quit;
    private Object listener;
    private static final Class[] BOOL_ARGS;
    static /* synthetic */ Class class$abbot$editor$OSXAdapter;

    private static synchronized Object application() {
        if (APPLICATION == null) {
            String cname = "com.apple.eawt.Application";
            try {
                APPLICATION = Class.forName(cname).newInstance();
            }
            catch (Exception e) {
                throw new Error("Can't load class " + cname + ": " + e);
            }
        }
        return APPLICATION;
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    private OSXAdapter(Frame context, Action quit, Action about, Action prefs) {
        this.source = new WeakReference<Frame>(context);
        this.quit = quit;
        this.about = about;
        this.prefs = prefs;
        try {
            Object app = OSXAdapter.application();
            Class<?> iface = Class.forName("com.apple.eawt.ApplicationListener");
            this.listener = Proxy.newProxyInstance((class$abbot$editor$OSXAdapter == null ? (class$abbot$editor$OSXAdapter = OSXAdapter.class$("abbot.editor.OSXAdapter")) : class$abbot$editor$OSXAdapter).getClassLoader(), new Class[]{iface}, (InvocationHandler)this);
            Method m = app.getClass().getDeclaredMethod("addApplicationListener", iface);
            m.invoke(app, this.listener);
            OSXAdapter.enablePrefs(prefs != null);
            OSXAdapter old = adapters.put(context, this);
            if (old instanceof OSXAdapter) {
                old.unregister();
            }
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }

    private void unregister() {
        try {
            Object app = OSXAdapter.application();
            Class<?> iface = Class.forName("com.apple.eawt.ApplicationListener");
            Method m = app.getClass().getDeclaredMethod("removeApplicationListener", iface);
            m.invoke(app, this.listener);
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }

    private void setHandled(Object event, boolean handled) {
        try {
            Method m = event.getClass().getDeclaredMethod("setHandled", BOOL_ARGS);
            m.invoke(event, new Boolean(handled));
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }

    private Object getSource() {
        Object src = this.source.get();
        if (src == null) {
            this.unregister();
        } else {
            Frame[] frames = Frame.getFrames();
            for (int i = 0; i < frames.length; ++i) {
                if (!frames[i].isActive() || src != frames[i]) continue;
                return src;
            }
        }
        return null;
    }

    private ActionEvent createEvent(Object src, Action action) {
        return new ActionEvent(src, 1001, (String)action.getValue("Name"), System.currentTimeMillis(), 0);
    }

    public void handleAbout(Object e) {
        Object src;
        this.setHandled(e, true);
        if (this.about != null && (src = this.getSource()) != null) {
            this.about.actionPerformed(this.createEvent(src, this.about));
        }
    }

    public void handlePreferences(Object e) {
        Object src;
        this.setHandled(e, true);
        if (this.prefs != null && (src = this.getSource()) != null) {
            this.prefs.actionPerformed(this.createEvent(src, this.prefs));
        }
    }

    public void handleQuit(Object e) {
        this.setHandled(e, false);
        Object src = this.getSource();
        if (src != null) {
            this.quit.actionPerformed(this.createEvent(src, this.quit));
        }
    }

    public void handleReOpenApplication(Object e) {
    }

    public void handleOpenApplication(Object e) {
    }

    public void handleOpenFile(Object e) {
    }

    public void handlePrintFile(Object e) {
    }

    public static void register(Frame owner, Action quit, Action about, Action prefs) {
        if (OSXAdapter.isMac()) {
            if (owner == null) {
                throw new NullPointerException("Parent Frame may not be null");
            }
            if (quit == null) {
                throw new NullPointerException("Quit action may not be null");
            }
            new OSXAdapter(owner, quit, about, prefs);
        }
    }

    public static void unregister(Frame owner) {
        InvocationHandler adapter;
        Object listener;
        if (OSXAdapter.isMac() && (listener = adapters.get(owner)) != null && (adapter = Proxy.getInvocationHandler(listener)) instanceof OSXAdapter) {
            ((OSXAdapter)adapter).unregister();
        }
    }

    public static void enablePrefs(boolean enabled) {
        if (OSXAdapter.isMac()) {
            try {
                Object app = OSXAdapter.application();
                Method m = app.getClass().getDeclaredMethod("setEnabledPreferencesMenu", BOOL_ARGS);
                m.invoke(app, new Boolean(enabled));
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if ("handleAbout".equals(name)) {
            this.handleAbout(args[0]);
        } else if ("handlePreferences".equals(name)) {
            this.handlePreferences(args[0]);
        } else if ("handleQuit".equals(name)) {
            this.handleQuit(args[0]);
        } else if ("handleReOpenApplication".equals(name)) {
            this.handleReOpenApplication(args[0]);
        } else if ("handleOpenApplication".equals(name)) {
            this.handleOpenApplication(args[0]);
        } else if ("handleOpenFile".equals(name)) {
            this.handleOpenFile(args[0]);
        } else if ("handlePrintFile".equals(name)) {
            this.handlePrintFile(args[0]);
        } else {
            throw new Error("Unimplemented method " + method);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        adapters = new WeakHashMap();
        BOOL_ARGS = new Class[]{Boolean.TYPE};
    }
}

