/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.editor.recorder.DialogRecorder;
import abbot.script.Action;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.script.Sequence;
import abbot.script.Step;
import java.awt.AWTEvent;
import java.awt.FileDialog;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FileDialogRecorder
extends DialogRecorder {
    private FileDialog dialog;
    private ComponentReference ref;
    private Map newRefs = new HashMap();
    private String originalFile;
    private String originalDir;
    static /* synthetic */ Class class$java$awt$FileDialog;

    public FileDialogRecorder(Resolver resolver) {
        super(resolver);
    }

    protected void init(int type) {
        super.init(type);
        this.dialog = null;
        this.ref = null;
        this.newRefs.clear();
        this.originalFile = null;
        this.originalDir = null;
    }

    protected boolean parseWindowEvent(AWTEvent event) {
        boolean consumed = true;
        if (event.getSource() instanceof FileDialog) {
            if (this.isOpen(event)) {
                this.dialog = (FileDialog)event.getSource();
                this.ref = ComponentReference.getReference(this.getResolver(), this.dialog, this.newRefs);
                this.originalFile = this.dialog.getFile();
                this.originalDir = this.dialog.getDirectory();
            }
            if (event instanceof FileDialogTerminator) {
                this.setFinished(true);
            } else if (event.getSource() == this.dialog && this.isClose(event)) {
                FileDialogTerminator terminator = new FileDialogTerminator(this.dialog, event.getID());
                this.dialog.getToolkit().getSystemEventQueue().postEvent(terminator);
            }
        }
        return consumed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Step createFileDialogEvents(FileDialog d, String oldDir, String oldFile) {
        String file = d.getFile();
        boolean accepted = file != null;
        boolean fileChanged = accepted && !file.equals(oldFile);
        String dir = d.getDirectory();
        boolean dirChanged = dir != oldDir && (dir == null || !dir.equals(oldDir));
        String desc = d.getMode() == 1 ? "Save File" : "Load File";
        desc = accepted ? desc + " (" + file + ")" : desc + " (canceled)";
        this.getResolver().addComponentReference(this.ref);
        Iterator i = this.newRefs.values().iterator();
        while (i.hasNext()) {
            this.getResolver().addComponentReference((ComponentReference)i.next());
        }
        Sequence seq = new Sequence(this.getResolver(), desc);
        if (dirChanged) {
            seq.addStep(new Action(this.getResolver(), null, "actionSetDirectory", new String[]{this.ref.getID(), dir}, class$java$awt$FileDialog == null ? (class$java$awt$FileDialog = FileDialogRecorder.class$("java.awt.FileDialog")) : class$java$awt$FileDialog));
        }
        if (accepted) {
            Action accept = new Action(this.getResolver(), null, "actionAccept", new String[]{this.ref.getID()}, class$java$awt$FileDialog == null ? (class$java$awt$FileDialog = FileDialogRecorder.class$("java.awt.FileDialog")) : class$java$awt$FileDialog);
            if (!fileChanged) return accept;
            seq.addStep(new Action(this.getResolver(), null, "actionSetFile", new String[]{this.ref.getID(), file}, class$java$awt$FileDialog == null ? (class$java$awt$FileDialog = FileDialogRecorder.class$("java.awt.FileDialog")) : class$java$awt$FileDialog));
            seq.addStep(accept);
            return seq;
        } else {
            Action cancel = new Action(this.getResolver(), null, "actionCancel", new String[]{this.ref.getID()}, class$java$awt$FileDialog == null ? (class$java$awt$FileDialog = FileDialogRecorder.class$("java.awt.FileDialog")) : class$java$awt$FileDialog);
            if (!dirChanged) return cancel;
            seq.addStep(cancel);
        }
        return seq;
    }

    protected Step createStep() {
        if (this.getRecordingType() == 1) {
            return this.createFileDialogEvents(this.dialog, this.originalDir, this.originalFile);
        }
        return super.createStep();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FileDialogTerminator
    extends WindowEvent {
        public FileDialogTerminator(FileDialog fd, int id) {
            super(fd, id);
        }
    }
}

