/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import abbot.Platform;
import abbot.editor.OSXAdapter;
import abbot.tester.KeyStrokeMap;
import abbot.tester.RobotVerifier;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class MapGenerator
extends KeyStrokeMap {
    private static KeyWatcher watcher = null;
    private static final int UNTYPED = -1;
    private static final int UNDEFINED = -2;
    private static final int ILLEGAL = -3;
    private static final int SYSTEM = -4;
    private static final int ERROR = -5;
    private static final Comparator FIELD_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            try {
                String n1 = ((Field)o1).getName();
                String n2 = ((Field)o2).getName();
                return n1.compareTo(n2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    };
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    private static boolean setModifiers(Robot robot, int mask, boolean press) {
        try {
            if ((mask & 1) != 0) {
                if (press) {
                    robot.keyPress(16);
                } else {
                    robot.keyRelease(16);
                }
            }
            if ((mask & 2) != 0) {
                if (press) {
                    robot.keyPress(17);
                } else {
                    robot.keyRelease(17);
                }
            }
            if ((mask & 8) != 0) {
                if (press) {
                    robot.keyPress(18);
                } else {
                    robot.keyRelease(18);
                }
            }
            if ((mask & 4) != 0) {
                if (press) {
                    robot.keyPress(157);
                } else {
                    robot.keyRelease(157);
                }
            }
            if ((mask & 0x20) != 0) {
                if (press) {
                    robot.keyPress(65406);
                } else {
                    robot.keyRelease(65406);
                }
            }
            return true;
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Log.warn(e);
        }
        return false;
    }

    private static int generateKey(final Window w, final Component c, final Robot robot, Point p, String name, int code, boolean refocus) {
        if (watcher == null) {
            watcher = new KeyWatcher();
            c.addKeyListener(watcher);
        }
        try {
            robot.waitForIdle();
            if (refocus) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        w.setVisible(true);
                        w.toFront();
                        c.requestFocus();
                        if (Platform.isWindows() || Platform.isMacintosh()) {
                            robot.mouseMove(w.getX() + w.getWidth() / 2, w.getY() + w.getHeight() / 2);
                            robot.mousePress(16);
                            robot.mouseRelease(16);
                        }
                    }
                });
            }
            robot.mouseMove(p.x, p.y);
            robot.waitForIdle();
            try {
                MapGenerator.watcher.codeName = name;
                MapGenerator.watcher.keyPressed = false;
                MapGenerator.watcher.keyTyped = false;
                robot.keyPress(code);
                robot.keyRelease(code);
                long start = System.currentTimeMillis();
                while (!(MapGenerator.watcher.keyPressed && MapGenerator.watcher.keyTyped || System.currentTimeMillis() - start > 500L)) {
                    robot.waitForIdle();
                }
                if (!MapGenerator.watcher.keyPressed) {
                    return -4;
                }
                if (!MapGenerator.watcher.keyTyped) {
                    return -1;
                }
                if (MapGenerator.watcher.keyChar == '\uffff') {
                    return -2;
                }
                return MapGenerator.watcher.keyChar;
            }
            catch (IllegalArgumentException e) {
                return -3;
            }
        }
        catch (Exception e) {
            Log.warn(e);
            return -5;
        }
    }

    private static boolean isFunctionKey(String name) {
        if (name.startsWith("VK_F")) {
            try {
                Integer.parseInt(name.substring(4));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static void generateKeyStrokeMap(Window w, JTextComponent c) {
        List<String> skip = Arrays.asList("VK_UNDEFINED", "VK_SHIFT", "VK_CONTROL", "VK_META", "VK_ALT", "VK_ALT_GRAPH", "VK_CAPS_LOCK", "VK_NUM_LOCK", "VK_SCROLL_LOCK", "VK_KANA", "VK_KANJI", "VK_ALPHANUMERIC", "VK_KATAKANA", "VK_HIRAGANA", "VK_FULL_WIDTH", "VK_HALF_WIDTH", "VK_ROMAN_CHARACTERS", "VK_ALL_CANDIDATES", "VK_PREVIOUS_CANDIDATE", "VK_CODE_INPUT", "VK_JAPANESE_KATAKANA", "VK_JAPANESE_HIRAGANA", "VK_JAPANESE_ROMAN", "VK_KANA_LOCK", "VK_INPUT_METHOD_ON_OFF");
        System.out.println("Generating keystroke map");
        try {
            int value;
            Robot robot = new Robot();
            if (!RobotVerifier.verify(robot)) {
                System.err.println("Robot non-functional, can't generate map");
                System.exit(1);
            }
            robot.delay(500);
            Field[] fields = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = MapGenerator.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getDeclaredFields();
            TreeSet<Field> codes = new TreeSet<Field>(FIELD_COMPARATOR);
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                if (!name.startsWith("VK_") || skip.contains(name) || name.startsWith("VK_DEAD_") || MapGenerator.isFunctionKey(name)) continue;
                codes.add(fields[i]);
            }
            System.out.println("Total VK_ fields read: " + codes.size());
            Point p = c.getLocationOnScreen();
            p.x += c.getWidth() / 2;
            p.y += c.getHeight() / 2;
            int[] modifierCombos = new int[]{0, 1, 2, 4, 8, 32};
            String[] MODIFIERS = new String[]{"none", "shift", "control", "meta", "alt", "alt graph"};
            int needRefocus = 12;
            Map[] maps = new Map[modifierCombos.length];
            for (int m = 0; m < modifierCombos.length; ++m) {
                TreeMap<Field, Integer> map = new TreeMap<Field, Integer>(FIELD_COMPARATOR);
                int mask = modifierCombos[m];
                if (!MapGenerator.setModifiers(robot, mask, true)) {
                    System.out.println("Modifier " + MODIFIERS[m] + " is not currently valid");
                    continue;
                }
                System.out.println("Generating keys with mask=" + MODIFIERS[m]);
                Iterator iter = codes.iterator();
                boolean focus = true;
                while (iter.hasNext()) {
                    Field f = (Field)iter.next();
                    int code = f.getInt(null);
                    System.out.print(".");
                    value = MapGenerator.generateKey(w, c, robot, p, f.getName(), code, focus || (mask & needRefocus) != 0);
                    map.put(f, new Integer(value));
                }
                MapGenerator.setModifiers(robot, modifierCombos[m], false);
                System.out.println("");
                maps[m] = map;
            }
            Properties props = new Properties();
            Iterator iter = maps[0].keySet().iterator();
            while (iter.hasNext()) {
                Field key = (Field)iter.next();
                for (int m = 0; m < modifierCombos.length; ++m) {
                    String hex;
                    Map map = maps[m];
                    if (map == null) continue;
                    String name = key.getName().substring(3);
                    name = name + "." + Integer.toHexString(modifierCombos[m]);
                    Integer v = (Integer)map.get(key);
                    value = v;
                    switch (value) {
                        case -1: {
                            hex = "untyped";
                            break;
                        }
                        case -2: {
                            hex = "undefined";
                            break;
                        }
                        case -3: {
                            hex = "illegal";
                            break;
                        }
                        case -4: {
                            hex = "system";
                            break;
                        }
                        case -5: {
                            hex = "error";
                            break;
                        }
                        default: {
                            hex = Integer.toHexString(value);
                        }
                    }
                    props.setProperty(name, hex);
                }
            }
            String[] names = MapGenerator.getMapNames();
            String[] desc = MapGenerator.getMapDescriptions();
            for (int i = 0; i < names.length; ++i) {
                String fn = MapGenerator.getFilename(names[i]);
                System.out.println("Saving " + names[i] + " as " + fn);
                FileOutputStream fos = new FileOutputStream(fn);
                props.store(fos, "Key mappings for " + desc[i]);
            }
        }
        catch (AWTException e) {
            System.err.println("Robot not available, can't generate map");
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
        }
    }

    public static void main(String[] args) {
        String language = System.getProperty("abbot.locale.language");
        if (language != null) {
            String country = System.getProperty("abbot.locale.country", "");
            String variant = System.getProperty("abbot.locale.variant", "");
            Locale.setDefault(new Locale(language, country, variant));
        }
        final JFrame frame = new JFrame("KeyStroke mapping generator");
        final JTextArea text = new JTextArea();
        text.setInputMap(0, new InputMap());
        frame.getContentPane().add(new JScrollPane(text));
        frame.setLocation(100, 100);
        frame.setSize(250, 90);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(final WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        e.getWindow().setVisible(true);
                    }
                });
            }
        });
        frame.setVisible(true);
        if (Platform.isOSX()) {
            OSXAdapter.register(frame, new AbstractAction("quit"){

                public void actionPerformed(ActionEvent e) {
                }
            }, null, null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new Thread("keymap generator"){

                    public void run() {
                        MapGenerator.generateKeyStrokeMap(frame, text);
                        System.exit(0);
                    }
                }.start();
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class KeyWatcher
    extends KeyAdapter {
        public char keyChar;
        public boolean keyTyped;
        public boolean keyPressed;
        public String codeName;

        private KeyWatcher() {
        }

        public void keyPressed(KeyEvent e) {
            this.keyPressed = true;
        }

        public void keyTyped(KeyEvent e) {
            this.keyChar = e.getKeyChar();
            this.keyTyped = true;
            this.codeName = null;
        }
    }
}

