/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.checkbox;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.DefaultContextVerifier;
import org.robotframework.swing.context.IContextVerifier;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.keyword.checkbox.CheckBoxOperatorFactory;
import org.robotframework.swing.operator.checkbox.MyCheckBoxOperator;

@RobotKeywords
public class CheckBoxKeywords {
    public static final String __PARANAMER_DATA = "\ncheckBoxShouldBeChecked java.lang.String identifier \n\ncheckBoxShouldBeUnChecked java.lang.String identifier \n\ncheckBoxShouldNotBeChecked java.lang.String identifier \n\ncheckCheckBox java.lang.String identifier \n\nuncheckCheckBox java.lang.String identifier \n";
    private OperatorFactory<MyCheckBoxOperator> operatorFactory = new CheckBoxOperatorFactory();
    private IContextVerifier contextVerifier = new DefaultContextVerifier();

    @RobotKeyword(value="Uses current context to search for a checkbox and when found, checks it.\n\nExample:\n| Check Checkbox | _My Checkbox_ |\n")
    public void checkCheckBox(String identifier) {
        this.contextVerifier.verifyContext();
        this.operatorFactory.createOperator(identifier).changeSelection(true);
    }

    @RobotKeyword(value="Uses current context to search for a checkbox and when found, unchecks it.\n\nExample:\n| Uncheck Checkbox | _My Checkbox_ |\n")
    public void uncheckCheckBox(String identifier) {
        this.contextVerifier.verifyContext();
        this.operatorFactory.createOperator(identifier).changeSelection(false);
    }

    @RobotKeyword(value="Fails if checkbox is not checked.\n\nExample:\n| Check Box Should Be Checked | _My Checkbox_ |\n")
    public void checkBoxShouldBeChecked(String identifier) {
        this.contextVerifier.verifyContext();
        Assert.assertTrue((boolean)this.operatorFactory.createOperator(identifier).isSelected());
    }

    @RobotKeyword(value="Fails if checkbox is checked.\n\nExample:\n| Check Box Should Be Un Checked | _My Checkbox_ |\n")
    public void checkBoxShouldBeUnChecked(String identifier) {
        this.contextVerifier.verifyContext();
        Assert.assertFalse((boolean)this.operatorFactory.createOperator(identifier).isSelected());
    }

    @RobotKeyword(value="Alias for `Check Box Should Be Un Checked` keyword.\n")
    public void checkBoxShouldNotBeChecked(String identifier) {
        this.checkBoxShouldBeUnChecked(identifier);
    }
}

