/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.combobox;

import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.comparator.EqualsStringComparator;
import org.robotframework.swing.context.DefaultContextVerifier;
import org.robotframework.swing.context.IContextVerifier;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.keyword.combobox.ComboBoxOperatorFactory;
import org.robotframework.swing.operator.combobox.MyComboBoxOperator;

@RobotKeywords
public class ComboBoxKeywords {
    public static final String __PARANAMER_DATA = "\ngetSelectedItemFromComboBox java.lang.String identifier \n\ngetSelectedItemFromDropdownMenu java.lang.String identifier \n\nselectFromComboBox java.lang.String,java.lang.String comboBoxIdentifier,comboItemIdentifier \n\nselectFromDropdownMenu java.lang.String,java.lang.String menuIdentifier,menuItemIdentifier \n";
    private OperatorFactory<MyComboBoxOperator> operatorFactory = new ComboBoxOperatorFactory();
    private IContextVerifier contextVerifier = new DefaultContextVerifier();

    @RobotKeyword(value="Selects an item from a combobox.\n\nExample:\n| Select From Combo Box | _myComboBox_ | _myItem_ | # Selects _'myItem'_ from combobox |\n| Select From Combo Box | _myComboBox_ | _0_      | # Selects the first item from combobox |\n")
    public void selectFromComboBox(String comboBoxIdentifier, String comboItemIdentifier) {
        this.contextVerifier.verifyContext();
        MyComboBoxOperator comboBoxOperator = this.operatorFactory.createOperator(comboBoxIdentifier);
        comboBoxOperator.pushComboButton();
        comboBoxOperator.selectItem(comboItemIdentifier, new EqualsStringComparator());
    }

    @RobotKeyword(value="Alias for `Select From Combobox` keyword.\n")
    public void selectFromDropdownMenu(String menuIdentifier, String menuItemIdentifier) {
        this.selectFromComboBox(menuIdentifier, menuItemIdentifier);
    }

    @RobotKeyword(value="Returns an item from a combobox.\n\nExample:\n| ${selectedItem}= | Get Selected Item From Combobox | _myComboBox_      |\n| Should Be Equal  | _item three_                    | _${selectedItem}_ |\n")
    public Object getSelectedItemFromComboBox(String identifier) {
        this.contextVerifier.verifyContext();
        return this.operatorFactory.createOperator(identifier).getSelectedItem();
    }

    @RobotKeyword(value="Alias for `Get Selected Item From Combobox` keyword.\n")
    public Object getSelectedItemFromDropdownMenu(String identifier) {
        return this.getSelectedItemFromComboBox(identifier);
    }
}

