/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.dialog;

import junit.framework.Assert;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.keyword.dialog.DialogOperatorFactory;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class DialogKeywords {
    public static final String __PARANAMER_DATA = "\ncloseDialog java.lang.String identifier \n\ndialogShouldBeOpen java.lang.String identifier \n\ndialogShouldNotBeOpen java.lang.String identifier \n\nselectDialog java.lang.String identifier \n";
    private IdentifierParsingOperatorFactory<JDialogOperator> operatorFactory = new DialogOperatorFactory();
    private IComponentConditionResolver dialogExistenceResolver = new ComponentExistenceResolver(this.operatorFactory);

    @RobotKeyword(value="Selects a dialog as current context.\n\nExample:\n| Select Dialog  | _About_ |\n")
    public void selectDialog(String identifier) {
        Context.setContext((ContainerOperator)this.operatorFactory.createOperator(identifier));
    }

    @RobotKeyword(value="Closes a dialog.\n\nExample:\n| Close Dialog | _About_ |\n")
    public void closeDialog(String identifier) {
        this.operatorFactory.createOperator(identifier).close();
    }

    @RobotKeyword(value="Fails if the dialog is not open.\n\nExample:\n| Dialog Should Be Open | _About_ |\n")
    public void dialogShouldBeOpen(String identifier) {
        Assert.assertTrue((String)("Dialog '" + identifier + "' is not open"), (boolean)this.dialogExistenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Fails if the dialog is open.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`.\n\nExample:\n| Set Jemmy Timeouts | _2_ |\n| Dialog Should Not Be Open | _About_ |\n")
    public void dialogShouldNotBeOpen(String identifier) {
        Assert.assertFalse((String)("Dialog '" + identifier + "' is open"), (boolean)this.dialogExistenceResolver.satisfiesCondition(identifier));
    }
}

