/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.label;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.DefaultContextVerifier;
import org.robotframework.swing.context.IContextVerifier;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.keyword.label.LabelOperatorFactory;
import org.robotframework.swing.operator.label.MyLabelOperator;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class LabelKeywords {
    public static final String __PARANAMER_DATA = "\ngetLabelContent java.lang.String identifier \n\nlabelShouldExist java.lang.String identifier \n\nlabelShouldNotExist java.lang.String identifier \n";
    private IdentifierParsingOperatorFactory<MyLabelOperator> operatorFactory = new LabelOperatorFactory();
    private IComponentConditionResolver labelExistenceResolver = new ComponentExistenceResolver(this.operatorFactory);
    private IContextVerifier contextVerifier = new DefaultContextVerifier();

    @RobotKeyword(value="Returns the text displayed on a label.\nAssumes that the label exists in the current context.\n\nExample:\n| ${labelText}=   | Get Label Content | _addressLabel_    |\n| Should Be Equal | _Address:_        | _${labelText}_ |\n")
    public String getLabelContent(String identifier) {
        this.contextVerifier.verifyContext();
        return this.operatorFactory.createOperator(identifier).getText();
    }

    @RobotKeyword(value="Fails if label does not exist within current context.\n\nExample:\n| Label Should Exist | _myLabel_ |\n")
    public void labelShouldExist(String identifier) {
        this.contextVerifier.verifyContext();
        Assert.assertTrue((String)("Label '" + identifier + "' doesn't exist"), (boolean)this.labelExistenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Fails if label exists within current context.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`.\n\nExample:\n| Set Jemmy Timeouts     | _1_ |\n| Label Should Not Exist | _myLabel_ |\n")
    public void labelShouldNotExist(String identifier) {
        this.contextVerifier.verifyContext();
        Assert.assertFalse((String)("Label '" + identifier + "' exists"), (boolean)this.labelExistenceResolver.satisfiesCondition(identifier));
    }
}

