/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.table;

import junit.framework.Assert;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.context.DefaultContextVerifier;
import org.robotframework.swing.context.IContextVerifier;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.table.EnhancedTableOperator;
import org.robotframework.swing.table.TableContextVerifier;
import org.robotframework.swing.table.TableOperatorFactory;

@RobotKeywords
public class TableKeywords {
    public static final String __PARANAMER_DATA = "\ngetTableColumnCount java.lang.String identifier \n\ngetTableRowCount java.lang.String identifier \n\ngetSelectedTableCellValue \n\ngetTableCellValue java.lang.String,java.lang.String row,columnIdentifier \n\nclearTableSelection \n\nselectTable java.lang.String identifier \n\nselectTableCell java.lang.String,java.lang.String row,cellIdentifier \n\nsetTableCellValue java.lang.String,java.lang.String,java.lang.String row,columnIdentifier,newValue \n\ntableCellShouldBeSelected java.lang.String,java.lang.String row,columnIdentifier \n\ntableCellShouldNotBeSelected java.lang.String,java.lang.String row,columnIdentifier \n";
    private OperatorFactory<EnhancedTableOperator> operatorFactory = new TableOperatorFactory();
    private IContextVerifier tableContextVerifier = new TableContextVerifier();
    private IContextVerifier contextVerifier = new DefaultContextVerifier();

    @RobotKeyword(value="Selects a table as current context.\n\nExample:\n| Select Table | _myTable_ |\n")
    public void selectTable(String identifier) {
        Context.setContext((ContainerOperator)this.operatorFactory.createOperator(identifier));
    }

    @RobotKeyword(value="Selects a cell.\nAssumes current context is a table.\n\nExample:\n| Select Table Cell | _0_ | _2_       | # Selects cell from first row and third column |\n| Select Table Cell | _1_ | _Keyword_ | # Selects cell from second row and column with header 'Keyword' |\n")
    public void selectTableCell(String row, String cellIdentifier) {
        this.tableContextVerifier.verifyContext();
        this.tableOperator().selectCell(row, cellIdentifier);
    }

    @RobotKeyword(value="Clears selection from table.\nAssumes current context is a table\n\nExample:\n| Clear Table Selection |\n")
    public void clearTableSelection() {
        this.tableContextVerifier.verifyContext();
        this.tableOperator().clearSelection();
    }

    @RobotKeyword(value="Fails if given table cell is not selected.\nAssumes current context is a table.\n\nExample:\n| Table Cell Should Be Selected | _0_ | _2_       |\n| Table Cell Should Be Selected | _1_ | _Keyword_ |\n")
    public void tableCellShouldBeSelected(String row, String columnIdentifier) {
        this.tableContextVerifier.verifyContext();
        Assert.assertTrue((String)("Cell '" + row + "', '" + columnIdentifier + "' is not selected."), (boolean)this.tableOperator().isCellSelected(row, columnIdentifier));
    }

    @RobotKeyword(value="Fails if given table cell is selected.\nAssumes current context is a table.\n\nExample:\n| Table Cell Should Be Selected | _0_ | _2_       |\n| Table Cell Should Be Selected | _1_ | _Keyword_ |\n")
    public void tableCellShouldNotBeSelected(String row, String columnIdentifier) {
        this.tableContextVerifier.verifyContext();
        Assert.assertFalse((String)("Cell '" + row + "', '" + columnIdentifier + "' is selected."), (boolean)this.tableOperator().isCellSelected(row, columnIdentifier));
    }

    @RobotKeyword(value="Returns cell's value.\nAssumes current context is a table.\n\nExample:\n| ${cellValue}=   | Get Table Cell Value   | _0_            | _2_ |\n| Should Be Equal | _tuesday_              | _${cellValue}_ |     |\n")
    public String getTableCellValue(String row, String columnIdentifier) {
        this.tableContextVerifier.verifyContext();
        return this.tableOperator().getValueAt(row, columnIdentifier).toString();
    }

    @RobotKeyword(value="Returns selected cell's value.\nAssumes current context is a table.\n\nExample:\n| ${cellValue}=   | Get Selected Table Cell Value   |              |\n| Should Be Equal | _tuesday_                       | _${cellValue}_ |\n")
    public Object getSelectedTableCellValue() {
        this.tableContextVerifier.verifyContext();
        int selectedRow = this.tableOperator().getSelectedRow();
        int selectedColumn = this.tableOperator().getSelectedColumn();
        return this.tableOperator().getValueAt(selectedRow, selectedColumn).toString();
    }

    @RobotKeyword(value="Sets the cell value.\nAssumes current context is a table.\n\nExample:\n| Set Table Cell Value | _1_ | _2_ | _New value_ |\n")
    public void setTableCellValue(String row, String columnIdentifier, String newValue) {
        this.tableContextVerifier.verifyContext();
        this.tableOperator().setValueAt(newValue, row, columnIdentifier);
    }

    @RobotKeyword(value="Returns the number of rows in the table.\n\nExample:\n| ${columnCount}= | Get Table Column Count | _myTable_ |\n| Should Be Equal As Integers | _4_ | _${columnCount}_ |\n")
    public int getTableColumnCount(String identifier) {
        this.contextVerifier.verifyContext();
        return this.operatorFactory.createOperator(identifier).getColumnCount();
    }

    @RobotKeyword(value="Returns the number of rows in the table.\n\nExample:\n| ${rowCount}= | Get Table Row Count | _myTable_ |\n| Should Be Equal As Integers | _5_ | _${rowCount}_ |\n")
    public int getTableRowCount(String identifier) {
        this.contextVerifier.verifyContext();
        return this.operatorFactory.createOperator(identifier).getRowCount();
    }

    private EnhancedTableOperator tableOperator() {
        return (EnhancedTableOperator)Context.getContext();
    }
}

