/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.tree.TreePathFactory;
import org.robotframework.swing.tree.TreeSupport;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class TreeNodeExistenceKeywords
extends TreeSupport {
    public static final String __PARANAMER_DATA = "\ntreeNodeShouldExist java.lang.String nodeIdentifier \n\ntreeNodeShouldNotExist java.lang.String nodeIdentifier \n";
    private IComponentConditionResolver treeNodeExistenceResolver = new ComponentExistenceResolver(new TreePathFactory());

    @RobotKeyword(value="Fails if the tree node does not exist.\n Assumes current context is a tree.\n\nExample:\n| Tree Node Should Exist | _Root|Folder_ |\n")
    public void treeNodeShouldExist(String nodeIdentifier) {
        Assert.assertTrue((String)("Tree node '" + nodeIdentifier + "' doesn't exist."), (boolean)this.treeNodeExistenceResolver.satisfiesCondition(nodeIdentifier));
    }

    @RobotKeyword(value="Fails if the tree node exists.\n Assumes current context is a tree.\n\nExample:\n| Tree Node Should Not Exist | _Root|Folder_ |\n")
    public void treeNodeShouldNotExist(String nodeIdentifier) {
        Assert.assertFalse((String)("Tree node '" + nodeIdentifier + "' exists."), (boolean)this.treeNodeExistenceResolver.satisfiesCondition(nodeIdentifier));
    }
}

