/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.tree.TreePathFactory;
import org.robotframework.swing.tree.TreeSupport;

@RobotKeywords
public class TreeNodeKeywords
extends TreeSupport {
    public static final String __PARANAMER_DATA = "\ncollapseTreeNode java.lang.String nodeIdentifier \n\nexpandTreeNode java.lang.String nodeIdentifier \n\nselectTreeNode java.lang.String nodeIdentifier \n\ntreeNodeShouldBeCollapsed java.lang.String nodeIdentifier \n\ntreeNodeShouldBeExpanded java.lang.String nodeIdentifier \n\ntreeNodeShouldBeLeaf java.lang.String nodeIdentifier \n\ntreeNodeShouldNotBeLeaf java.lang.String nodeIdentifier \n\nunselectTreeNode java.lang.String nodeIdentifier \n";
    private TreePathFactory treePathFactory = new TreePathFactory();

    @RobotKeyword(value="Collapses a tree node.\nAssumes current context is a tree.\n\nExamples:\n| Collapse Tree Node | _Root|Folder_ |\n| Collapse Tree Node | _3_ |\n")
    public void collapseTreeNode(String nodeIdentifier) {
        this.treeOperator().collapsePath(this.treePathFactory.createTreePath(nodeIdentifier));
    }

    @RobotKeyword(value="Expands a tree node.\nAssumes current context is a tree.\n\nExamples:\n| Expand Tree Node | _Root|Folder_ |\n| Expand Tree Node | _3_ |\n")
    public void expandTreeNode(String nodeIdentifier) {
        this.treeOperator().expandPath(this.treePathFactory.createTreePath(nodeIdentifier));
    }

    @RobotKeyword(value="Sets a tree node as selected.\nDoes not clear earlier selections. Assumes current context is a tree.\n\nExample:\n| Select Tree Node | _Root|Folder_ |\n")
    public void selectTreeNode(String nodeIdentifier) {
        this.treeOperator().addSelectionPath(this.treePathFactory.createTreePath(nodeIdentifier));
    }

    @RobotKeyword(value="Fails if the tree node is collapsed.\nAssumes current context is a tree.\n\nExample:\n| Tree Node Should Be Expanded | _Root|Folder_ |\n")
    public void treeNodeShouldBeExpanded(String nodeIdentifier) {
        TreePath treePath = this.treePathFactory.createTreePath(nodeIdentifier);
        Assert.assertTrue((String)("Tree node '" + nodeIdentifier + "' is not expanded."), (boolean)this.treeOperator().isExpanded(treePath));
    }

    @RobotKeyword(value="Fails if the tree node is expanded.\nAssumes current context is a tree.\n\nExample:\n| Tree Node Should Be Collapsed | _Root|Folder_ |\n")
    public void treeNodeShouldBeCollapsed(String nodeIdentifier) {
        TreePath treePath = this.treePathFactory.createTreePath(nodeIdentifier);
        Assert.assertTrue((String)("Tree node '" + nodeIdentifier + "' is not collapsed."), (boolean)this.treeOperator().isCollapsed(treePath));
    }

    @RobotKeyword(value="Sets a tree node as unselected.\nAssumes current context is a tree.\n\nExample:\n| Unselect Tree Node | _Root|Folder_ |\n")
    public void unselectTreeNode(String nodeIdentifier) {
        this.treeOperator().removeSelectionPath(this.treePathFactory.createTreePath(nodeIdentifier));
    }

    @RobotKeyword(value="Fails if the node has child nodes.\nAssumes current context is a tree.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`\n\nExample:\n| Tree Node Should Be Leaf | _Root|Folder_ |")
    public void treeNodeShouldBeLeaf(String nodeIdentifier) {
        TreeNode lastPathComponent = (TreeNode)this.treePathFactory.createTreePath(nodeIdentifier).getLastPathComponent();
        Assert.assertTrue((String)("Tree node '" + nodeIdentifier + "' is not leaf."), (boolean)lastPathComponent.isLeaf());
    }

    @RobotKeyword(value="Fails if the node doesn't have child nodes.\nAssumes current context is a tree.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`\n\nExample:\n| Tree Node Should Not Be Leaf | _Root|Folder_ |")
    public void treeNodeShouldNotBeLeaf(String nodeIdentifier) {
        TreeNode lastPathComponent = (TreeNode)this.treePathFactory.createTreePath(nodeIdentifier).getLastPathComponent();
        Assert.assertFalse((String)("Tree node '" + nodeIdentifier + "' is leaf."), (boolean)lastPathComponent.isLeaf());
    }
}

