/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.table;

import java.awt.Point;
import javax.swing.JTable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.robotframework.swing.arguments.IdentifierHandler;
import org.robotframework.swing.table.AbstractTableCellChooser;
import org.robotframework.swing.table.InvalidCellException;
import org.springframework.util.ObjectUtils;

public class EnhancedTableOperator
extends JTableOperator {
    public static final String __PARANAMER_DATA = "\n<init> javax.swing.JTable table \n\n<init> org.netbeans.jemmy.operators.ContainerOperator,int context,index \n\n<init> org.netbeans.jemmy.operators.ContainerOperator,org.netbeans.jemmy.ComponentChooser context,componentChooser \n\nisCellSelected java.lang.String,java.lang.String rowIdentifier,columnIdentifier \n\nfindCell java.lang.String,java.lang.String row,columnIdentifier \n\ngetValueAt java.lang.String,java.lang.String rowIdentifier,columnIdentifier \n\nselectCell java.lang.String,java.lang.String rowIdentifier,columnIdentifier \n\nsetValueAt java.lang.Object,java.lang.String,java.lang.String newValue,rowIdentifier,columnIdentifier \n";

    public EnhancedTableOperator(JTable table) {
        super(table);
    }

    public EnhancedTableOperator(ContainerOperator context, int index) {
        super(context, index);
    }

    public EnhancedTableOperator(ContainerOperator context, ComponentChooser componentChooser) {
        super(context, componentChooser);
    }

    public Object getValueAt(String rowIdentifier, String columnIdentifier) {
        Point coordinates = this.findCell(rowIdentifier, columnIdentifier);
        return this.getValueAt(coordinates.y, coordinates.x);
    }

    public boolean isCellSelected(String rowIdentifier, String columnIdentifier) {
        Point coordinates = this.findCell(rowIdentifier, columnIdentifier);
        return this.isCellSelected(coordinates.y, coordinates.x);
    }

    public void selectCell(String rowIdentifier, String columnIdentifier) {
        Point coordinates = this.findCell(rowIdentifier, columnIdentifier);
        this.selectCell(coordinates.y, coordinates.x);
    }

    public void setValueAt(Object newValue, String rowIdentifier, String columnIdentifier) {
        Point coordinates = this.findCell(rowIdentifier, columnIdentifier);
        this.setValueAt(newValue, coordinates.y, coordinates.x);
    }

    public Point findCell(String row, String columnIdentifier) {
        JTableOperator.TableCellChooser cellChooser = this.createCellChooser(row, columnIdentifier);
        Point cell = this.findCell(cellChooser);
        if (this.cellIsInvalid(cell)) {
            throw new InvalidCellException(row, columnIdentifier);
        }
        return cell;
    }

    private boolean cellIsInvalid(Point cell) {
        return cell.x < 0 || cell.y < 0;
    }

    private JTableOperator.TableCellChooser createCellChooser(String row, String columnIdentifier) {
        return new CellChooserFactory(row).createCellChooser(columnIdentifier);
    }

    private Object getColumHeader(int columnIndex) {
        return this.getColumnModel().getColumn(columnIndex).getHeaderValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CellChooserFactory
    extends IdentifierHandler<JTableOperator.TableCellChooser> {
        public static final String __PARANAMER_DATA = "\n<init> java.lang.String rowAsString \n\ncreateCellChooser java.lang.String columnIdentifier \n\nindexArgument int column \n\nnameArgument java.lang.String columnHeader \n";
        private int row;

        public CellChooserFactory(String rowAsString) {
            this.row = Integer.parseInt(rowAsString);
        }

        @Override
        public JTableOperator.TableCellChooser indexArgument(final int column) {
            return new AbstractTableCellChooser(this.row){

                protected boolean checkColumn(int index) {
                    return column == index;
                }
            };
        }

        @Override
        public JTableOperator.TableCellChooser nameArgument(final String columnHeader) {
            return new AbstractTableCellChooser(this.row){

                protected boolean checkColumn(int columnIndex) {
                    return ObjectUtils.nullSafeEquals((Object)columnHeader, (Object)EnhancedTableOperator.this.getColumHeader(columnIndex));
                }
            };
        }

        public JTableOperator.TableCellChooser createCellChooser(String columnIdentifier) {
            return (JTableOperator.TableCellChooser)this.parseArgument(columnIdentifier);
        }
    }
}

