/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.util.AWT;
import abbot.util.WeakAWTEventListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ContainerEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LookAndFeelPreserver {
    private LookAndFeel laf;
    private Map owned = new WeakHashMap();
    private AWTEventListener listener;
    private Frame frame;
    private JPanel trigger;

    public LookAndFeelPreserver(Component c) {
        this(UIManager.getLookAndFeel(), c);
    }

    public LookAndFeelPreserver(final LookAndFeel laf, Component c) {
        this.laf = laf;
        this.add(c);
        this.listener = new AWTEventListener(){

            public void eventDispatched(AWTEvent e) {
                if (e.getID() == 300) {
                    LookAndFeelPreserver.this.componentAdded(((ContainerEvent)e).getChild());
                }
            }
        };
        new WeakAWTEventListener(this.listener, 2L);
        String name = "updateComponentTreeUI Listener";
        this.frame = new Frame(name);
        this.frame.setName(name);
        this.trigger = new JPanel(){
            private boolean initialized = true;

            public void updateUI() {
                if (this.initialized) {
                    SwingUtilities.invokeLater(new LAFRestorer(laf, LookAndFeelPreserver.this.owned));
                }
            }
        };
        this.frame.add(this.trigger);
    }

    public void add(Component c) {
        this.owned.put(c, Boolean.TRUE);
        if (c instanceof Window) {
            Window[] subs = ((Window)c).getOwnedWindows();
            for (int i = 0; i < subs.length; ++i) {
                this.add(subs[i]);
            }
        }
    }

    private void componentAdded(Component c) {
        Window w = AWT.getWindow(c);
        if (w != null && (this.owned.containsKey(w) || this.owned.containsKey(w.getParent()))) {
            if (!this.owned.containsKey(w)) {
                this.add(w);
            }
            SwingUtilities.invokeLater(new LAFRestorer(this.laf, c));
        }
    }

    private static class LAFRestorer
    implements Runnable {
        private LookAndFeel laf;
        private Map map;

        public LAFRestorer(LookAndFeel laf, Component c) {
            this(laf, new WeakHashMap());
            this.map.put(c, Boolean.TRUE);
        }

        public LAFRestorer(LookAndFeel laf, Map map) {
            this.laf = laf;
            this.map = map;
        }

        public void run() {
            LookAndFeel current = UIManager.getLookAndFeel();
            if (current != this.laf && current != null && !current.equals(this.laf)) {
                try {
                    UIManager.setLookAndFeel(this.laf);
                    Iterator iter = this.map.keySet().iterator();
                    while (iter.hasNext()) {
                        Component c = (Component)iter.next();
                        SwingUtilities.updateComponentTreeUI(c);
                    }
                    UIManager.setLookAndFeel(current);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
            }
        }
    }
}

