/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.AssertionFailedError;
import abbot.BugReport;
import abbot.ExitException;
import abbot.Log;
import abbot.NoExitSecurityManager;
import abbot.Platform;
import abbot.editor.ComponentBrowser;
import abbot.editor.ComponentBrowserListener;
import abbot.editor.Costello;
import abbot.editor.EditorConstants;
import abbot.editor.EditorContext;
import abbot.editor.FileSystemHelper;
import abbot.editor.HierarchyWriter;
import abbot.editor.OSXAdapter;
import abbot.editor.Preferences;
import abbot.editor.ScriptEditorFrame;
import abbot.editor.ScriptModel;
import abbot.editor.ScriptTable;
import abbot.editor.TestSelector;
import abbot.editor.actions.EditorAction;
import abbot.editor.actions.EditorToggleAction;
import abbot.editor.editors.AppletviewerEditor;
import abbot.editor.editors.LaunchEditor;
import abbot.editor.editors.StepChangeListener;
import abbot.editor.editors.StepEditor;
import abbot.editor.recorder.EventRecorder;
import abbot.editor.recorder.Recorder;
import abbot.editor.recorder.RecordingFailedException;
import abbot.editor.widgets.Highlighter;
import abbot.editor.widgets.SpinningDialWaitIndicator;
import abbot.editor.widgets.TextField;
import abbot.editor.widgets.TextFormat;
import abbot.finder.AWTHierarchy;
import abbot.finder.Hierarchy;
import abbot.finder.TestHierarchy;
import abbot.i18n.Strings;
import abbot.script.Annotation;
import abbot.script.Appletviewer;
import abbot.script.ArgumentParser;
import abbot.script.Assert;
import abbot.script.Call;
import abbot.script.Comment;
import abbot.script.ComponentReference;
import abbot.script.EventExceptionHandler;
import abbot.script.Expression;
import abbot.script.Fixture;
import abbot.script.InvalidScriptException;
import abbot.script.Launch;
import abbot.script.NoSuchReferenceException;
import abbot.script.Resolver;
import abbot.script.Sample;
import abbot.script.Script;
import abbot.script.ScriptFilter;
import abbot.script.Sequence;
import abbot.script.Step;
import abbot.script.StepEvent;
import abbot.script.StepListener;
import abbot.script.StepRunner;
import abbot.script.Terminate;
import abbot.script.UIContext;
import abbot.tester.ComponentTester;
import abbot.tester.ImageComparator;
import abbot.tester.InputState;
import abbot.tester.Robot;
import abbot.util.AWT;
import abbot.util.AWTFixtureHelper;
import abbot.util.Bugs;
import abbot.util.EventNormalizer;
import abbot.util.Launcher;
import abbot.util.PathClassLoader;
import abbot.util.SingleThreadedEventListener;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import junit.extensions.TestDecorator;
import junit.extensions.abbot.ScriptFixture;
import junit.extensions.abbot.ScriptTestSuite;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ScriptEditor
implements ActionListener,
Resolver,
EditorConstants {
    private static int selectKey;
    private static int captureKey;
    private static int captureImageKey;
    private static final boolean LOG_ALL_EVENTS;
    private static final long FIXTURE_EVENT_MASK;
    public static final int KC_INVERT = 16;
    public static final int KC_WAIT;
    private static final int INFO = 0;
    private static final int WARN = 1;
    private static final int ERROR = 2;
    private static final int FAILURE = 3;
    private static final String[] statusFormat;
    private static final Color[] statusColor;
    private ArrayList insertActions = new ArrayList();
    private ArrayList assertActions = new ArrayList();
    private ArrayList waitActions = new ArrayList();
    private ArrayList captureActions = new ArrayList();
    private ScriptModel scriptModel;
    private ScriptTable scriptTable;
    private SecurityManager securityManager;
    private SecurityManager oldSecurityManager;
    private int nonce;
    private ThreadGroup appGroup;
    private TestHierarchy hierarchy;
    private Hierarchy oldHierarchy;
    private Recorder[] recorders;
    private SpinningDialWaitIndicator waiter;
    private boolean rootIsExiting = true;
    private boolean exiting;
    private boolean hiding;
    private boolean ignoreStepEvents;
    private boolean ignoreEvents;
    private boolean isScriptRunning;
    private long lastLaunchTime;
    private boolean capturingImage;
    private Component captureComponent;
    private Component innermostCaptureComponent;
    private Highlighter highlighter;
    private boolean isRootEditor = true;
    private static InputState state;
    private ScriptFilter filter = new ScriptFilter();
    private Class testClass;
    private ScriptTestSuite testSuite;
    private Script testScript;
    private File tempFile;
    private StepRunner runner;
    private List testScriptList;
    private Component selectedComponent;
    private ComponentReference selectedReference;
    private boolean recording;
    private Recorder recorder;
    private boolean justStoppedRecording;
    private boolean ignoreComboBox;
    private Step stopStep;
    private JFileChooser chooser;
    private ScriptEditorFrame view;
    private ComboBoxModel model;
    private boolean invertAssertions;
    private boolean waitAssertions;
    private ActionMap actionMap;
    private String name;
    private EditorContext editorConfiguration;
    private RecordAllAction recordAllAction;
    private RecordAllAction recordAllMotionAction;
    private EventNormalizer normalizer = new EventNormalizer();
    private int DONT_CARE = -1;
    private static ScriptEditor editor;
    static /* synthetic */ Class class$abbot$tester$ComponentTester;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$junit$extensions$abbot$ScriptFixture;
    static /* synthetic */ Class class$junit$extensions$abbot$ScriptTestSuite;
    static /* synthetic */ Class class$abbot$editor$ScriptEditor;

    public ScriptEditor(EditorContext ec) {
        this.editorConfiguration = ec;
        if (ec.isEmbedded()) {
            this.name = "Script Editor (emdedded)";
        } else if (Boolean.getBoolean("abbot.framework.launched")) {
            this.isRootEditor = false;
            this.name = "Script Editor (under test)";
        } else {
            System.setProperty("abbot.framework.launched", "true");
            this.name = "Script Editor (root)";
        }
        this.actionMap = this.initActions();
        this.hierarchy = this.initContext(this.isRootEditor);
        this.recorders = this.initRecorders();
        this.view = this.initFrame(this.isRootEditor);
        this.hierarchy.setFiltered(this.view, true);
        this.updateDynamicActions(this.view);
        this.view.setComponentBrowser(this.createComponentBrowser());
        this.addEventHandlers(this.view);
        if (this.view.getStatus().equals(Strings.get("Initializing"))) {
            this.setStatus(Strings.get("Ready"));
        }
        this.rootIsExiting = false;
    }

    private String[][] initMenus() {
        ArrayList<String> fileMenu = new ArrayList<String>();
        ArrayList<String> helpMenu = new ArrayList<String>();
        fileMenu.addAll(Arrays.asList("menus.file", "script-new", "script-duplicate", "script-open", null, "script-save", "script-save-as", "script-rename", "script-close", null, "script-delete"));
        helpMenu.add("menus.help");
        if (!Platform.isOSX()) {
            fileMenu.add(null);
            fileMenu.add("editor-quit");
            helpMenu.add("editor-about");
        }
        helpMenu.addAll(Arrays.asList("editor-userguide", "editor-website", "editor-email", "editor-submit-bug"));
        return new String[][]{fileMenu.toArray(new String[fileMenu.size()]), {"menus.edit", "step-cut", null, "step-move-up", "step-move-down", "step-group", null, "select-component", null, "script-clear"}, {"menus.test", "run", "run-to", "run-selected", null, "export-hierarchy", null, "run-launch", "run-terminate", null, "toggle-stop-on-failure", "toggle-stop-on-error", "toggle-forked", "run-get-vmargs", "toggle-slow-playback", "toggle-awt-mode"}, {"menus.insert", "insert-annotation", "insert-applet", "insert-call", "insert-comment", "insert-expression", "insert-launch", "insert-fixture", "insert-sample", "insert-script", "insert-sequence", "insert-terminate"}, {"menus.capture"}, helpMenu.toArray(new String[helpMenu.size()])};
    }

    private ActionMap initActions() {
        Action[] actions = new Action[]{new EditorAboutAction(), new EditorEmailAction(), new EditorBugReportAction(), new EditorWebsiteAction(), new EditorUserGuideAction(), new EditorQuitAction(), new ScriptOpenAction(), new ScriptNewAction(), new ScriptDuplicateAction(), new ScriptSaveAction(), new ScriptSaveAsAction(), new ScriptRenameAction(), new ScriptCloseAction(), new ScriptDeleteAction(), new ScriptClearAction(), new StepCutAction(), new StepMoveUpAction(), new StepMoveDownAction(), new StepGroupAction(), new RunAction(), new RunToAction(), new RunSelectedAction(), new RunLaunchAction(), new RunTerminateAction(), new GetVMArgsAction(), new SelectTestSuiteAction(), new ExportHierarchyAction(), new ToggleForkedAction(), new InsertLaunchAction(), new InsertFixtureAction(), new InsertAppletAction(), new InsertTerminateAction(), new InsertCallAction(), new InsertSampleAction(), new InsertSequenceAction(), new InsertScriptAction(), new InsertCommentAction(), new InsertExpressionAction(), new InsertAnnotationAction(), new ToggleStopOnFailureAction(), new ToggleStopOnErrorAction(), new ToggleSlowPlaybackAction(), new ToggleAWTModeAction(), new CaptureImageAction(), new CaptureComponentAction(), new SelectComponentAction()};
        ActionMap map = new ActionMap();
        for (int i = 0; i < actions.length; ++i) {
            Object key = actions[i].getValue("action-key");
            map.put(key, actions[i]);
        }
        return map;
    }

    private void addEventHandlers(final ScriptEditorFrame view) {
        this.scriptTable.getSelectionModel().addListSelectionListener(new ScriptTableSelectionHandler());
        this.scriptTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if ((me.getModifiers() & 0x10) != 0 && view.getEditor() == null) {
                    ScriptEditor.this.setStepEditor();
                }
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if ((me.getModifiers() & 0x10) != 0) {
                    int size = ScriptEditor.this.scriptTable.getRowCount();
                    ScriptEditor.this.scriptTable.clearSelection();
                    ScriptEditor.this.scriptTable.setCursorLocation(size);
                }
            }
        };
        view.addMouseListener(ml);
        view.getTestScriptSelector().addItemListener(new ScriptSelectorItemHandler());
        view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ScriptEditor.this.quitApplication();
            }
        });
        if (Platform.isOSX()) {
            OSXAdapter.register(view, this.actionMap.get("editor-quit"), this.actionMap.get("editor-about"), null);
        }
    }

    private TestHierarchy initContext(boolean isRoot) {
        TestHierarchy hierarchy = this.editorConfiguration.getTestHierarchy();
        if (hierarchy == null) {
            hierarchy = new TestHierarchy(){
                private String desc;
                {
                    this.desc = "Test hierarchy for " + ScriptEditor.this.name;
                }

                public String toString() {
                    return this.desc;
                }
            };
        }
        this.oldHierarchy = AWTHierarchy.getDefault();
        if (isRoot) {
            AWTHierarchy.setDefault(hierarchy);
            this.initSecurityManager();
            try {
                new EventExceptionHandler().install();
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
        return hierarchy;
    }

    private Recorder[] initRecorders() {
        Recorder[] recorders = new Recorder[]{new EventRecorder(this, false), new EventRecorder(this, true)};
        ActionListener recorderListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ScriptEditor.this.setStatus(event.getActionCommand());
            }
        };
        for (int i = 0; i < recorders.length; ++i) {
            recorders[i].addActionListener(recorderListener);
        }
        return recorders;
    }

    private ScriptEditorFrame initFrame(final boolean isRoot) {
        this.scriptModel = new ScriptModel(){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.runner = new EditorStepRunner();
        this.runner.setTerminateOnError(false);
        this.runner.addStepListener(new StepListener(){

            public void stateChanged(StepEvent ev) {
                if (ScriptEditor.this.ignoreStepEvents) {
                    return;
                }
                ScriptEditor.this.reflectScriptExecutionState(ev);
            }
        });
        this.scriptTable = new ScriptTable(this.scriptModel){

            public Color getStepColor(Step step, boolean selected) {
                Throwable thr;
                Color color = super.getStepColor(step, selected);
                if (step == ScriptEditor.this.stopStep) {
                    Color stopColor;
                    color = stopColor = this.getSelectionBackground().darker();
                }
                if ((thr = ScriptEditor.this.runner.getError(step)) != null) {
                    Color tint;
                    Color color2 = tint = thr instanceof AssertionFailedError ? statusColor[3] : statusColor[2];
                    if (step instanceof Sequence) {
                        color = color.brighter();
                    }
                    color = selected ? ScriptEditor.this.mixColors(color, tint) : tint;
                }
                return color;
            }
        };
        ActionMap amap = this.scriptTable.getActionMap();
        amap.put("cut", this.actionMap.get("step-cut"));
        InputMap imap = this.scriptTable.getInputMap();
        imap.put(KeyStroke.getKeyStroke(32, 0), "toggle");
        String prefFile = ".abbot.properties";
        if (!isRoot) {
            prefFile = prefFile + ".tmp";
        }
        Preferences prefs = new Preferences(prefFile);
        String title = Strings.get("ScriptEditor.title", new Object[]{""});
        ScriptEditorFrame f = new ScriptEditorFrame(this.initMenus(), this.actionMap, this, title, this.scriptTable, prefs){

            public void hide() {
                if (ScriptEditor.this.hiding || ScriptEditor.this.isDisposeFromRootEditor()) {
                    ScriptEditor.this.hiding = false;
                    super.hide();
                }
            }

            public void dispose() {
                if (ScriptEditor.this.exiting || ScriptEditor.this.isDisposeFromRootEditor()) {
                    super.dispose();
                }
            }

            public String getName() {
                String name = super.getName();
                if (isRoot) {
                    name = name + " (root)";
                }
                return name;
            }
        };
        return f;
    }

    private Color mixColors(Color c1, Color c2) {
        return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
    }

    private boolean isDisposeFromRootEditor() {
        return !this.isRootEditor && Boolean.getBoolean("abbot.finder.disposal");
    }

    private void createAsserts(ArrayList list, ComponentTester tester, boolean wait) {
        int i;
        list.clear();
        Method[] methods = tester.getAssertMethods();
        for (i = 0; i < methods.length; ++i) {
            list.add(new TesterMethodAction(tester, methods[i], wait));
        }
        methods = tester.getComponentAssertMethods();
        if (list.size() != 0 && methods.length != 0) {
            list.add(null);
        }
        for (i = 0; i < methods.length; ++i) {
            list.add(new TesterMethodAction(tester, methods[i], wait));
        }
        methods = tester.getPropertyMethods();
        if (list.size() != 0 && methods.length != 0) {
            list.add(null);
        }
        for (i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (name.startsWith("is")) {
                name = name.substring(2);
            } else if (name.startsWith("get") || name.startsWith("has")) {
                name = name.substring(3);
            }
            list.add(new TesterMethodAction(tester, methods[i], wait));
        }
    }

    private Step captureComponentImage(Component comp) {
        Assert step = null;
        ComponentTester tester = ComponentTester.getTester(comp);
        BufferedImage img = tester.capture(comp, !(comp instanceof Window));
        try {
            ComponentReference ref = this.addComponent(comp);
            File scriptFile = ((Script)this.getResolverContext()).getFile();
            File newFile = new File(this.getResolverContext().getDirectory(), scriptFile.getName() + "-" + ref.getID() + ImageComparator.IMAGE_SUFFIX);
            int index = 1;
            while (newFile.exists()) {
                newFile = new File(this.getResolverContext().getDirectory(), scriptFile.getName() + "-" + ref.getID() + "-" + index++ + ImageComparator.IMAGE_SUFFIX);
            }
            ImageComparator.writeImage(newFile, img);
            step = new Assert(this.getResolverContext(), null, (class$abbot$tester$ComponentTester == null ? (class$abbot$tester$ComponentTester = ScriptEditor.class$("abbot.tester.ComponentTester")) : class$abbot$tester$ComponentTester).getName(), "assertImage", new String[]{ref.getID(), newFile.getName(), "true"}, "true", false);
        }
        catch (IOException io) {
            Log.warn(io);
        }
        return step;
    }

    private void startRecording(Recorder rec) {
        boolean canLaunch;
        Log.debug("Starting recorder");
        boolean noWindows = this.countShowingWindows(null) == 0;
        boolean bl = canLaunch = this.testScript != null && this.testScript.hasLaunch() && !this.isAppLaunched();
        if (noWindows && !canLaunch) {
            this.view.showError(Strings.get("NoWindows.title"), Strings.get("NoWindows"));
        } else {
            if (this.recorder != null) {
                this.stopRecording(true);
            }
            Log.debug("Now recording with " + rec);
            this.recording = true;
            this.recorder = rec;
            this.setStatus("Please wait...");
            if (!noWindows) {
                this.view.toBack();
            }
            this.recorder.start();
            if (noWindows) {
                this.launch(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRecording(boolean discardRecording) {
        Log.debug("Stopping recorder");
        this.recording = false;
        int type = 0;
        String extended = null;
        String status = Strings.get(discardRecording ? "RecorderCanceled" : "RecorderFinished");
        try {
            this.recorder.terminate();
        }
        catch (RecordingFailedException e) {
            String msg = Strings.get("editor.recording.stop_failure");
            Throwable error = e.getReason() instanceof BugReport ? e.getReason() : new BugReport(msg, e.getReason());
            Log.log("Recording stop failure: " + error.toString());
            this.view.showWarning(msg);
            status = error.getMessage();
            extended = error.toString();
            type = 2;
        }
        try {
            Step step;
            if (!(discardRecording || (step = this.recorder.getStep()) instanceof Sequence && ((Sequence)step).size() == 0)) {
                this.addStep(step);
            }
        }
        finally {
            this.recorder = null;
            if (this.waiter != null) {
                this.waiter.dispose();
                this.waiter = null;
            }
        }
        this.view.toFront();
        this.setStatus(status, extended, type);
    }

    private void updateDynamicActions(ScriptEditorFrame view) {
        TesterMethodAction action;
        int i;
        Class clazz = this.selectedComponent == null ? (class$java$awt$Component == null ? (class$java$awt$Component = ScriptEditor.class$("java.awt.Component")) : class$java$awt$Component) : this.selectedComponent.getClass();
        Class cls = clazz;
        ComponentTester tester = ComponentTester.getTester(cls);
        this.createAsserts(this.assertActions, tester, false);
        this.createAsserts(this.waitActions, tester, true);
        this.insertActions.clear();
        HashMap<String, TesterMethodAction> map = new HashMap<String, TesterMethodAction>();
        Method[] methods = tester.getActions();
        for (i = 0; i < methods.length; ++i) {
            action = new TesterMethodAction(tester, methods[i], true);
            map.put(action.getName(), action);
        }
        methods = tester.getComponentActions();
        for (i = 0; i < methods.length; ++i) {
            action = new TesterMethodAction(tester, methods[i], true);
            map.put(action.getName(), action);
        }
        this.insertActions.addAll(map.values());
        this.captureActions.clear();
        this.recordAllAction = new RecordAllAction("capture", this.recorders[0], false);
        this.captureActions.add(this.recordAllAction);
        this.recordAllMotionAction = new RecordAllAction("capture-all", this.recorders[1], true);
        this.captureActions.add(this.recordAllMotionAction);
        this.captureActions.add(null);
        this.captureActions.add(new CaptureImageAction());
        this.captureActions.add(new CaptureComponentAction());
        view.populateInsertMenu(this.insertActions);
        view.populateAssertMenu(this.assertActions);
        view.populateWaitMenu(this.waitActions);
        view.populateCaptureMenu(this.captureActions);
    }

    private void setSelected(String which, boolean select) {
        Action action = this.actionMap.get(which);
        if (action != null) {
            ((EditorToggleAction)action).setSelected(select);
        } else {
            Log.warn("Toggle action " + which + " is missing");
        }
    }

    private void setEnabled(String which, boolean enable) {
        if (which == "dynamic-actions") {
            ArrayList[] lists = new ArrayList[]{this.captureActions, this.waitActions, this.assertActions, this.insertActions};
            for (int i = 0; i < lists.length; ++i) {
                Iterator iter = lists[i].iterator();
                while (iter.hasNext()) {
                    Action action = (Action)iter.next();
                    if (action == null) continue;
                    action.setEnabled(enable);
                }
            }
        } else {
            Action action = this.actionMap.get(which);
            if (action != null) {
                action.setEnabled(enable);
            } else {
                Log.warn("Action " + which + " is missing");
            }
        }
    }

    private ComponentBrowser createComponentBrowser() {
        ComponentBrowser cb = new ComponentBrowser(this, this.hierarchy);
        cb.setEnabled(false);
        cb.addSelectionListener(new ComponentBrowserListener(){

            public void selectionChanged(ComponentBrowser src, Component comp, ComponentReference ref) {
                ScriptEditor.this.setSelectedComponent(comp, ref);
            }

            public void propertyAction(ComponentBrowser src, Method m, Object value, boolean sample) {
                if (ScriptEditor.this.selectedComponent == null) {
                    return;
                }
                ScriptEditor.this.addPropertyMethodCall(m, value, sample);
            }
        });
        return cb;
    }

    private void initSecurityManager() {
        if (Boolean.getBoolean("abbot.no_security_manager")) {
            return;
        }
        this.securityManager = this.editorConfiguration.getSecurityManager();
        if (this.securityManager == null) {
            this.securityManager = new EditorSecurityManager();
        }
        try {
            this.oldSecurityManager = System.getSecurityManager();
            System.setSecurityManager(this.securityManager);
        }
        catch (Exception e) {
            this.securityManager = null;
            this.oldSecurityManager = null;
            Log.warn(e);
        }
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.view.getTestScriptSelector() && !this.ignoreComboBox) {
            Script script = (Script)this.view.getTestScriptSelector().getSelectedItem();
            if (script != this.testScript) {
                this.setScript(script);
            }
        } else if (ev.getSource() == this.view.getTestScriptDescription()) {
            if (this.testScript != null) {
                JTextField tf = this.view.getTestScriptDescription();
                String desc = tf.getText();
                if ("".equals(desc)) {
                    String cmd = ev.getActionCommand();
                    if (!TextField.isDocumentAction(cmd)) {
                        tf.setText(this.testScript.getDefaultDescription());
                        this.testScript.setDescription(null);
                    }
                } else if (!desc.equals(this.testScript.getDefaultDescription())) {
                    this.testScript.setDescription(desc);
                }
            }
        } else {
            Log.warn("Unrecognized event: " + ev.getActionCommand() + "(" + ev.getID() + ")");
        }
    }

    private void cutSelection() {
        int row = this.scriptTable.getSelectedRow();
        if (row == -1) {
            Log.warn("Unexpected cut state");
            return;
        }
        this.scriptModel.removeSteps(this.scriptTable.getSelectedSteps());
        int count = this.scriptTable.getRowCount();
        if (count > 0) {
            if (row >= count) {
                row = count - 1;
            }
            this.scriptTable.setRowSelectionInterval(row, row);
            this.scriptTable.setCursorLocation(row + 1);
        }
        this.setActionsEnabledState();
        this.setStatus("");
    }

    private void moveSelectionUp() {
        this.scriptTable.moveUp();
        this.setActionsEnabledState();
    }

    private void moveSelectionDown() {
        this.scriptTable.moveDown();
        this.setActionsEnabledState();
    }

    private void groupSelection() {
        int row = this.scriptTable.getSelectedRow();
        Sequence seq = new Sequence(this.getResolverContext(), (String)null);
        List list = this.scriptTable.getSelectedSteps();
        Step first = (Step)list.get(0);
        Sequence parent = this.scriptModel.getParent(first);
        int index = parent.indexOf(first);
        this.scriptModel.removeSteps(list);
        Iterator iter = list.iterator();
        Step last = parent;
        while (iter.hasNext()) {
            last = (Step)iter.next();
            seq.addStep(last);
        }
        this.scriptModel.insertStep(parent, seq, index);
        this.scriptModel.toggle(row);
        this.scriptTable.setRowSelectionInterval(row, this.scriptModel.getRowOf(last));
        this.setActionsEnabledState();
    }

    void insertLaunch() {
        Launch step = new Launch(this.getResolverContext(), LaunchEditor.HELP_DESC, "abbot.editor.ScriptEditor", "main", new String[]{"[]"}, ".", false);
        this.addStep(step);
    }

    void insertApplet() {
        Appletviewer step = new Appletviewer(this.getResolverContext(), AppletviewerEditor.HELP_DESC, "your.applet.class.here", new HashMap(), null, null, null);
        this.addStep(step);
    }

    void insertTerminate() {
        Terminate step = new Terminate(this.getResolverContext(), (String)null);
        this.scriptTable.setCursorLocation(this.scriptTable.getRowCount());
        this.addStep(step);
    }

    private void insertCall(boolean sample) {
        if (sample) {
            this.addStep(new Sample(this.getResolverContext(), null, Strings.get("YourClassName"), Strings.get("YourMethodName"), null, Strings.get("YourPropertyName")));
        } else {
            this.addStep(new Call(this.getResolverContext(), null, Strings.get("YourClassName"), Strings.get("YourMethodName"), null));
        }
    }

    private void insertSequence() {
        this.addStep(new Sequence(this.getResolverContext(), (String)null, null));
    }

    private void insertComment() {
        this.addStep(new Comment(this.getResolverContext(), ""));
    }

    private void insertExpression() {
        this.addStep(new Expression(this.getResolverContext(), ""));
    }

    private void insertAnnotation() {
        this.addStep(new Annotation(this.getResolverContext(), ""));
    }

    private void insertScript(boolean fixture) {
        JFileChooser chooser = this.getChooser(this.filter);
        chooser.setCurrentDirectory(this.getWorkingDirectory());
        if (chooser.showOpenDialog(this.view) == 0) {
            File file = chooser.getSelectedFile();
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    this.view.showError(e.toString());
                }
            }
            Script script = fixture ? new Fixture(file.getAbsolutePath(), this.hierarchy) : new Script(file.getAbsolutePath(), this.hierarchy);
            try {
                script.load();
                this.addStep(script);
            }
            catch (Exception exc) {
                this.view.showError(exc.toString());
            }
        }
    }

    private File getWorkingDirectory() {
        return this.testSuite != null ? this.testSuite.getDirectory() : (this.testScript != null && !this.editingTempFile() ? this.testScript.getDirectory() : new File(System.getProperty("user.dir")));
    }

    private JFileChooser getChooser(FileFilter f) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setCurrentDirectory(this.getWorkingDirectory());
        }
        this.chooser.setFileFilter(f);
        return this.chooser;
    }

    private void setScript(int index) {
        if (this.getScripts().size() == 0) {
            this.setScript((Script)null);
            if (this.testSuite != null) {
                this.setStatus(Strings.get("NoScripts"), null, 1);
            }
        } else {
            if (index >= this.getScripts().size()) {
                index = this.getScripts().size() - 1;
            }
            this.setScript(this.getScriptAt(index));
        }
    }

    private void setScript(Script script) {
        UIContext context;
        if (script == this.testScript && script != null) {
            return;
        }
        Log.debug("Setting script to '" + script + "'");
        if (script != null) {
            try {
                script.load();
            }
            catch (InvalidScriptException ise) {
                Log.warn(ise);
                this.setScript((String)null);
                this.view.showError("Invalid Script", ise.toString());
                return;
            }
            catch (Exception e) {
                this.setScript((String)null);
                Log.warn(e);
                return;
            }
        }
        if (this.testScript != null && (context = this.testScript.getUIContext()) != null && !context.equivalent(this.runner.getCurrentContext())) {
            this.runner.terminate();
        }
        this.testScript = script;
        this.scriptTable.clearSelection();
        this.scriptModel.setScript(script);
        if (script == null) {
            this.scriptTable.setCursorLocation(0);
            this.scriptTable.setEnabled(false);
            this.view.getTestScriptDescription().setText("");
            this.view.getTestScriptDescription().setEnabled(false);
            this.setStatus(Strings.get("NoScript"));
        } else {
            this.scriptTable.setEnabled(true);
            this.scriptTable.setCursorLocation(script.hasLaunch() ? 1 : 0);
            if (this.chooser != null) {
                this.chooser.setCurrentDirectory(script.getDirectory());
            }
            this.view.getTestScriptDescription().setText(script.getDescription());
            this.view.getTestScriptDescription().setEnabled(true);
            this.setStatus(Strings.get("editor.editing_script", new Object[]{this.testScript.getName()}));
        }
        this.setActionsEnabledState();
        this.ignoreComboBox = true;
        this.view.getTestScriptSelector().setSelectedItem(this.testScript);
        this.ignoreComboBox = false;
        this.updateTitle();
    }

    private void setActionsEnabledState() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ScriptEditor.this.setActionsEnabledState();
                }
            });
            return;
        }
        boolean haveScript = this.testScript != null;
        boolean haveSelection = this.scriptTable.getSelectedRow() != -1;
        boolean notEmdedded = !this.editorConfiguration.isEmbedded();
        this.setEnabled("script-open", true);
        this.setEnabled("toggle-stop-on-failure", haveScript);
        this.setSelected("toggle-stop-on-failure", haveScript && this.runner.getStopOnFailure());
        this.setEnabled("toggle-stop-on-error", haveScript);
        this.setSelected("toggle-stop-on-error", haveScript && this.runner.getStopOnError());
        this.setEnabled("toggle-forked", haveScript);
        this.setSelected("toggle-forked", haveScript && this.testScript.isForked());
        this.setEnabled("run-get-vmargs", haveScript && this.testScript.isForked());
        this.setEnabled("toggle-slow-playback", haveScript);
        this.setSelected("toggle-slow-playback", haveScript && this.testScript.isSlowPlayback());
        this.setEnabled("toggle-awt-mode", haveScript);
        this.setSelected("toggle-awt-mode", haveScript && this.testScript.isAWTMode());
        this.setEnabled("run", haveScript);
        this.setEnabled("run-to", haveScript && haveSelection);
        this.setEnabled("run-selected", haveScript && haveSelection && this.isAppLaunched());
        this.setEnabled("export-hierarchy", haveScript && this.isAppLaunched());
        this.setEnabled("run-launch", haveScript && notEmdedded && this.testScript.hasLaunch() && !this.isAppLaunched());
        this.setEnabled("run-terminate", this.isAppLaunched() && notEmdedded);
        this.setEnabled("script-new", true);
        this.setEnabled("script-duplicate", haveScript);
        this.setEnabled("script-save", haveScript);
        this.setEnabled("script-save-as", haveScript);
        this.setEnabled("script-rename", haveScript);
        this.setEnabled("script-delete", haveScript);
        this.setEnabled("script-close", haveScript);
        this.setEnabled("step-cut", haveScript && haveSelection);
        this.setEnabled("step-move-up", haveScript && haveSelection && this.scriptTable.canMoveUp());
        this.setEnabled("step-move-down", haveScript && haveSelection && this.scriptTable.canMoveDown());
        this.setEnabled("step-group", haveScript && haveSelection);
        this.setEnabled("script-clear", haveScript);
        this.setEnabled("insert-launch", notEmdedded && haveScript && !this.testScript.hasLaunch());
        this.setEnabled("insert-fixture", haveScript && !this.testScript.hasLaunch());
        this.setEnabled("insert-applet", notEmdedded && haveScript && !this.testScript.hasLaunch());
        this.setEnabled("insert-terminate", notEmdedded && haveScript && !this.testScript.hasTerminate());
        this.setEnabled("insert-script", haveScript);
        this.setEnabled("insert-call", haveScript);
        this.setEnabled("insert-sample", haveScript);
        this.setEnabled("insert-sequence", haveScript);
        this.setEnabled("insert-comment", haveScript);
        this.setEnabled("insert-expression", haveScript);
        this.setEnabled("insert-annotation", haveScript);
        this.setEnabled("dynamic-actions", haveScript);
        this.view.getComponentBrowser().setEnabled(!this.isScriptRunning);
    }

    void setScript(String filename) {
        Script script = filename != null ? new Script(filename, this.hierarchy) : null;
        this.setScript(script);
    }

    private void setSelectedComponent(Component c, ComponentReference ref) {
        if (c == this.selectedComponent && ref == this.selectedReference) {
            return;
        }
        boolean updateActions = c != this.selectedComponent;
        this.selectedComponent = c;
        this.selectedReference = ref;
        String status = ref != null ? Strings.get(c == null ? "ComponentReferenceX" : "ComponentReference", new Object[]{ref.getID()}) : (c != null ? (this.hierarchy.contains(c) ? Strings.get("UnreferencedComponent") : Strings.get("editor.component_filtered")) : Strings.get("NoComponent"));
        this.setStatus(status);
        if (updateActions) {
            this.updateDynamicActions(this.view);
        }
    }

    private void setTestSuite(String suiteClassname) {
        this.setTestSuite(suiteClassname, null);
    }

    private void setTestSuite(String suiteClassname, ClassLoader cl) {
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        Log.debug("Setting test suite to " + suiteClassname);
        this.testSuite = null;
        this.testScriptList = null;
        if (suiteClassname != null) {
            try {
                Class<?> cls = Class.forName(suiteClassname, true, cl);
                if (!(class$junit$extensions$abbot$ScriptFixture == null ? (class$junit$extensions$abbot$ScriptFixture = ScriptEditor.class$("junit.extensions.abbot.ScriptFixture")) : class$junit$extensions$abbot$ScriptFixture).isAssignableFrom(cls) && !(class$junit$extensions$abbot$ScriptTestSuite == null ? (class$junit$extensions$abbot$ScriptTestSuite = ScriptEditor.class$("junit.extensions.abbot.ScriptTestSuite")) : class$junit$extensions$abbot$ScriptTestSuite).isAssignableFrom(cls)) {
                    this.view.showWarning(Strings.get("editor.wrong_class", new Object[]{cls.getName()}));
                } else {
                    this.testClass = cls;
                    Method suiteMethod = null;
                    this.testSuite = null;
                    try {
                        suiteMethod = this.testClass.getMethod("suite", new Class[0]);
                        this.testSuite = (ScriptTestSuite)((Object)suiteMethod.invoke(null, (Object[])new Class[0]));
                    }
                    catch (NoSuchMethodException nsm) {
                        this.view.showError(nsm.toString());
                        this.testSuite = null;
                    }
                    catch (InvocationTargetException ite) {
                        this.view.showError(ite.toString());
                    }
                    catch (IllegalAccessException iae) {
                        this.view.showError(iae.toString());
                    }
                }
            }
            catch (ClassNotFoundException e) {
                this.view.showWarning(Strings.get("editor.suite_not_found", new Object[]{suiteClassname}));
            }
        }
        if (this.testSuite == null) {
            this.view.getCurrentTestSuiteLabel().setText(Strings.get("NoSuite"));
            this.model = new DefaultComboBoxModel();
            this.view.getTestScriptSelector().setModel(this.model);
            this.view.getTestScriptSelector().setEnabled(false);
            this.model.setSelectedItem(null);
        } else {
            this.view.getTestScriptSelector().setEnabled(true);
            this.view.getCurrentTestSuiteLabel().setText(this.testSuite.toString());
            Object oldSelection = this.view.getTestScriptSelector().getSelectedItem();
            this.ignoreComboBox = true;
            this.view.getTestScriptSelector().setEnabled(true);
            this.view.getTestScriptSelector().setSelectedItem(null);
            List list = this.getScripts();
            Object[] data = list.toArray(new Object[list.size()]);
            this.model = new DefaultComboBoxModel<Object>(data);
            this.view.getTestScriptSelector().setModel(this.model);
            if (this.getScripts().contains(oldSelection)) {
                this.model.setSelectedItem(oldSelection);
            }
            this.ignoreComboBox = false;
        }
    }

    private void updateTitle() {
        String title = Strings.get("ScriptEditor.title", new Object[]{this.testScript != null ? " (" + this.testScript.getName() + ")" : ""});
        this.view.setTitle(title);
    }

    private void browseTests() {
        String path;
        ClassLoader cl = this.getContextClassLoader();
        String string = path = cl instanceof PathClassLoader ? ((PathClassLoader)cl).getClassPath() : null;
        if (path == null) {
            path = System.getProperty("java.class.path");
        }
        TestSelector selector = new TestSelector((Frame)this.view, path);
        selector.setVisible(true);
        String className = selector.getSelectedItem();
        if (className != null && this.checkSaveBeforeClose()) {
            this.terminate();
            boolean none = className.equals("<None>");
            this.setTestSuite(none ? null : className, cl);
            this.setScript(0);
            if (none) {
                this.setStatus(Strings.get("editor.no_suite"));
            }
        }
    }

    protected boolean checkSaveBeforeClose() {
        if (this.testScript != null && this.testScript.isDirty()) {
            int opt = this.view.showConfirmation(Strings.get("ScriptModified"), 1);
            if (opt == 2 || opt == -1) {
                return false;
            }
            if (opt == 0) {
                this.saveScript();
            }
        }
        return true;
    }

    private void closeScript() {
        if (!this.checkSaveBeforeClose()) {
            return;
        }
        this.setScript((Script)null);
    }

    void quitApplication() {
        if (!this.checkSaveBeforeClose()) {
            return;
        }
        Log.debug("editor quit" + (this.isRootEditor ? " (root)" : ""));
        this.dispose();
        if (this.isRootEditor) {
            this.rootIsExiting = true;
        } else {
            AWTHierarchy.setDefault(this.oldHierarchy);
        }
        if (!this.editorConfiguration.isEmbedded()) {
            System.exit(0);
        }
    }

    public void setStatus(String msg) {
        this.setStatus(msg, null, 0);
    }

    private String getStackTrace(Throwable thr) {
        StringWriter writer = new StringWriter();
        thr.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public void setStatus(String msg, String extended, int type) {
        String text = Strings.get(statusFormat[type], new Object[]{msg});
        this.view.setStatus(text, extended, statusColor[type]);
        Log.log(text);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setStatusForStep(Step step) {
        if (step == null) {
            this.setStatus("");
            return;
        }
        Throwable error = this.runner.getError(step);
        boolean fromScript = step == this.testScript;
        String msg = error != null ? error.toString() : null;
        String inStep = Strings.get("InStep", new Object[]{step});
        String where = Strings.get("StepAt", new Object[]{Script.getFile(step), new Integer(Script.getLine(step))}) + "\n";
        if (error instanceof AssertionFailedError && ((AssertionFailedError)((Object)error)).getLine() != 0) {
            where = "";
        }
        String extended = null;
        int type = 0;
        if (error != null) {
            Log.log(error);
            boolean isFailure = error instanceof AssertionFailedError;
            type = isFailure ? 3 : 2;
            extended = this.getStackTrace(error);
            if (fromScript) {
                if ((!isFailure || this.runner.getStopOnFailure()) && (isFailure || this.runner.getStopOnError())) return;
                msg = Strings.get(isFailure ? "ScriptFailure" : "ScriptError");
            } else {
                extended = inStep + "\n" + where + extended;
            }
        } else if (fromScript) {
            msg = Strings.get("ScriptSuccess");
        }
        if (msg == null) return;
        this.setStatus(msg, extended, type);
    }

    private String getSelectedComponentID() {
        String id = null;
        if (this.selectedReference != null) {
            id = this.selectedReference.getID();
        } else if (this.selectedComponent != null) {
            ComponentReference ref = this.addComponent(this.selectedComponent);
            id = ref.getID();
            this.setStatus(Strings.get("ComponentReference", new Object[]{id}));
        }
        return id;
    }

    private void addTesterCall(Method method, ComponentTester tester, boolean wait, String docs) {
        Class<?> componentClass;
        boolean invert = this.invertAssertions;
        Class<?>[] params = method.getParameterTypes();
        String id = this.getSelectedComponentID();
        Class<?> clazz = componentClass = this.selectedComponent != null ? this.selectedComponent.getClass() : null;
        boolean componentArg0 = params.length > 0 && (class$java$awt$Component == null ? (class$java$awt$Component = ScriptEditor.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(params[0]);
        String argString = this.view.showInputDialog(Strings.get("IdentifyArguments"), docs, componentArg0 ? id : null);
        if (argString == null) {
            return;
        }
        String[] args = ArgumentParser.parseArgumentList(argString);
        try {
            this.insertTesterCall(tester, method, componentClass, id, args, wait, invert);
        }
        catch (IllegalArgumentException iae) {
            Log.warn(iae);
        }
        catch (NoSuchReferenceException nsr) {
            Log.warn(nsr);
        }
    }

    private void addPropertyMethodCall(Method method, Object value, boolean sample) {
        String[] stringArray;
        String id = this.getSelectedComponentID();
        String methodName = method.getName();
        if ((class$abbot$tester$ComponentTester == null ? (class$abbot$tester$ComponentTester = ScriptEditor.class$("abbot.tester.ComponentTester")) : class$abbot$tester$ComponentTester).isAssignableFrom(method.getDeclaringClass())) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = id;
        } else {
            stringArray = null;
        }
        String[] args = stringArray;
        String targetClassName = method.getDeclaringClass().getName();
        if (sample) {
            String varName = Strings.get("YourPropertyName");
            Sample step = args == null ? new Sample(this.getResolverContext(), null, methodName, id, varName) : new Sample(this.getResolverContext(), null, targetClassName, methodName, args, varName);
            this.addStep(step);
        } else {
            String expectedValue = ArgumentParser.toString(value);
            Assert step = args == null ? new Assert(this.getResolverContext(), null, methodName, id, expectedValue, this.invertAssertions) : new Assert(this.getResolverContext(), null, targetClassName, methodName, args, expectedValue, this.invertAssertions);
            step.setWait(this.waitAssertions);
            this.addStep(step);
        }
    }

    public String getComponentID(Component comp) {
        ComponentReference ref = this.getComponentReference(comp);
        return ref != null ? ref.getID() : null;
    }

    void addStep(Step step) {
        Sequence parent = this.scriptTable.getCursorParent();
        int index = this.scriptTable.getCursorParentIndex();
        this.scriptModel.insertStep(parent, step, index);
        int row = this.scriptModel.getRowOf(step);
        this.scriptTable.setRowSelectionInterval(row, row);
        this.scriptTable.setCursorLocation(row + 1);
        this.setActionsEnabledState();
    }

    private void newScript(boolean copyFixture) {
        if (!this.checkSaveBeforeClose()) {
            return;
        }
        File file = this.editorConfiguration.getNewFileTemplate();
        if (file == null) {
            try {
                this.tempFile = file = File.createTempFile(Script.UNTITLED_FILE, ".xml");
            }
            catch (IOException io) {
                JFileChooser chooser = this.getChooser(this.filter);
                File dir = this.getWorkingDirectory();
                chooser.setCurrentDirectory(dir);
                chooser.setSelectedFile(new File(dir, Script.UNTITLED_FILE + ".xml"));
                if (chooser.showSaveDialog(this.view) != 0) {
                    return;
                }
                file = chooser.getSelectedFile();
            }
        }
        if (!file.exists() || file.isFile()) {
            this.newScript(file, copyFixture);
        }
    }

    void newScript(File file, boolean copyFixture) {
        if (!this.checkSaveBeforeClose()) {
            return;
        }
        try {
            boolean insert = file.createNewFile() || file.length() == 0L;
            Script srcFixture = this.testScript;
            this.setScript(file.getAbsolutePath());
            if (insert) {
                if (!copyFixture || srcFixture == null) {
                    this.insertTerminate();
                    this.insertLaunch();
                } else {
                    this.copyFixture(srcFixture);
                }
            }
            this.setStatus(Strings.get(copyFixture ? "FixtureDuplicated" : "NewScriptCreated", new Object[]{file.getName()}));
        }
        catch (IOException io) {
            this.view.showError("File Error", io.toString());
        }
    }

    public void copyFixture(Script src) {
        Assert wait;
        Step first = src.getStep(0);
        Step last = src.getStep(src.size() - 1);
        if (first instanceof UIContext) {
            this.setStatus(Strings.get("editor.adding_launch"));
            this.addStep(first);
        }
        if (src.size() > 1 && src.getStep(1) instanceof Assert && (wait = (Assert)src.getStep(1)).isWait() && wait.getMethodName().equals("assertFrameShowing")) {
            this.setStatus(Strings.get("editor.adding_wait"));
            this.addStep(wait);
        }
        if (last instanceof Terminate) {
            this.setStatus(Strings.get("editor.adding_terminate"));
            this.addStep(last);
        }
    }

    private void launch(boolean terminateRecorder) {
        if (this.testScript == null) {
            Log.warn("null testScript");
            return;
        }
        this.ignoreStepEvents = true;
        this.invertAssertions = false;
        this.waitAssertions = false;
        this.view.setAssertOptions(this.waitAssertions, this.invertAssertions);
        if (terminateRecorder && this.recorder != null) {
            this.stopRecording(false);
        }
        this.setStatus(Strings.get("Launching"));
        this.runSteps(this.testScript, true, Strings.get("LaunchingDone"), new Runnable(){

            public void run() {
                ScriptEditor.this.ignoreStepEvents = false;
            }
        });
    }

    private void terminate() {
        if (this.recorder != null) {
            this.stopRecording(false);
        }
        this.scriptTable.clearSelection();
        try {
            this.runner.terminate();
        }
        catch (Throwable e) {
            Log.warn(e);
        }
    }

    private void openScript() {
        if (!this.checkSaveBeforeClose()) {
            return;
        }
        JFileChooser chooser = this.getChooser(this.filter);
        chooser.setCurrentDirectory(this.getWorkingDirectory());
        if (this.testScript != null) {
            chooser.setSelectedFile(this.testScript.getFile());
        }
        if (chooser.showOpenDialog(this.view) == 0) {
            File file = chooser.getSelectedFile();
            this.setScript(file.getAbsolutePath());
        }
        if (!this.getScripts().contains(this.testScript) && this.model != null) {
            this.model.setSelectedItem(null);
        }
    }

    private void stopOnFailureToggle() {
        if (this.testScript != null) {
            this.runner.setStopOnFailure(!this.runner.getStopOnFailure());
        }
    }

    private void stopOnErrorToggle() {
        if (this.testScript != null) {
            this.runner.setStopOnError(!this.runner.getStopOnError());
        }
    }

    private void forkedToggle() {
        if (this.testScript != null) {
            this.testScript.setForked(!this.testScript.isForked());
        }
        this.setActionsEnabledState();
    }

    private void getVMArgs() {
        String args = this.view.showInputDialog(Strings.get("GetVMArgs.title"), Strings.get("GetVMArgs.msg"), this.testScript.getVMArgs());
        if (args != null) {
            this.testScript.setVMArgs(args);
        }
    }

    private void slowPlaybackToggle() {
        if (this.testScript != null) {
            this.testScript.setSlowPlayback(!this.testScript.isSlowPlayback());
        }
    }

    private void awtModeToggle() {
        if (this.testScript != null) {
            this.testScript.setAWTMode(!this.testScript.isAWTMode());
        }
    }

    private void runScript(Step stopAt) {
        if (this.testScript == null) {
            Log.warn("null testScript");
            return;
        }
        Log.debug("Running test case " + this.testScript);
        this.stopStep = stopAt;
        this.setStatus(Strings.get("actions.run.start"));
        Runnable completion = new Runnable(){

            public void run() {
                ScriptEditor.this.view.toFront();
            }
        };
        this.runSteps(this.testScript, false, Strings.get("actions.run.finish"), completion);
    }

    private void exportHierarchy() {
        JFileChooser chooser = this.getChooser(null);
        if (chooser.showSaveDialog(this.view) == 0) {
            this.setStatus(Strings.get("actions.export-hierarchy.start"));
            final File file = chooser.getSelectedFile();
            new Thread("Hierarchy Export"){

                public void run() {
                    HierarchyWriter hw = new HierarchyWriter(ScriptEditor.this.hierarchy);
                    try {
                        FileWriter writer = new FileWriter(file);
                        hw.writeHierarchy(writer);
                    }
                    catch (IOException io) {
                        ScriptEditor.this.view.showError(Strings.get("SaveFailed.title"), io.toString());
                    }
                    ScriptEditor.this.setStatus(Strings.get("actions.export-hierarchy.finish"));
                }
            }.start();
        }
    }

    private void runSelectedSteps() {
        List stepList = this.scriptTable.getSelectedSteps();
        if (this.testScript == null || stepList == null || stepList.size() == 0 || !this.isAppLaunched()) {
            Log.warn("inconsistent program state");
            return;
        }
        Sequence steps = new Sequence(this.getResolverContext(), null, stepList);
        final int row0 = this.scriptModel.getRowOf((Step)stepList.get(0));
        final int row1 = this.scriptModel.getRowOf((Step)stepList.get(steps.size() - 1));
        this.setStatus(Strings.get("actions.run-selected.start"));
        this.hideView();
        this.runSteps(steps, false, Strings.get("actions.run-selected.finish"), new Runnable(){

            public void run() {
                ScriptEditor.this.scriptTable.setRowSelectionInterval(row0, row1);
                ScriptEditor.this.view.setVisible(true);
            }
        });
    }

    private void runSteps(Step which, boolean launch, String completionMessage, Runnable onCompletion) {
        Log.debug("running " + which);
        this.setActionsEnabledState();
        this.lastLaunchTime = System.currentTimeMillis();
        LaunchAction action = new LaunchAction(which, onCompletion, completionMessage, launch);
        String groupName = "AUT Thread Group for " + this + ":" + this.nonce++;
        if (this.appGroup == null) {
            this.appGroup = new ThreadGroup(groupName){

                public void uncaughtException(Thread t, Throwable thrown) {
                    if (!(thrown instanceof ExitException) && !(thrown instanceof ThreadDeath)) {
                        Log.warn("Application thread exception not caught: " + t);
                        Log.warn(thrown);
                    }
                }
            };
        }
        Thread launcher = new Thread(this.appGroup, action, "Script runner:" + this.nonce);
        launcher.setDaemon(true);
        this.view.getComponentBrowser().setEnabled(false);
        this.view.setEditor(null);
        this.isScriptRunning = true;
        launcher.start();
    }

    private void clearScript() {
        if (this.testScript == null) {
            Log.warn("null testScript");
            return;
        }
        if (this.view.showConfirmation(Strings.get("editor.confirm.clear_script")) == 0) {
            this.scriptTable.clearSelection();
            this.scriptTable.setCursorLocation(0);
            this.testScript.clear();
            this.scriptModel.setScript(this.testScript);
        }
    }

    private void deleteScript() {
        if (this.testScript == null) {
            Log.warn("null testScript");
            return;
        }
        if (this.view.showConfirmation(Strings.get("editor.confirm.delete_script")) == 0) {
            File file = this.testScript.getFile();
            int index = this.view.getTestScriptSelector().getSelectedIndex();
            file.delete();
            this.setTestSuite(this.testClass.getName(), this.testClass.getClassLoader());
            this.setScript(index);
        }
    }

    private void saveAsScript(boolean rename) {
        if (this.testScript == null) {
            Log.warn("null testScript");
            return;
        }
        File oldFile = this.testScript.getFile();
        JFileChooser chooser = this.getChooser(this.filter);
        chooser.setCurrentDirectory(this.getWorkingDirectory());
        Log.debug("Showing save dialog");
        if (chooser.showSaveDialog(this.view) == 0) {
            Log.debug("Accepted");
            File newFile = chooser.getSelectedFile();
            if (rename && !oldFile.renameTo(newFile)) {
                this.view.showError(Strings.get("editor.save.rename_failed", new Object[]{oldFile, newFile}));
                return;
            }
            this.testScript.setFile(newFile);
            this.saveScript();
            this.updateTitle();
            if (this.testSuite != null && this.testSuite.accept(newFile)) {
                this.setTestSuite(this.testClass.getName(), ((Object)((Object)this.testSuite)).getClass().getClassLoader());
            } else {
                this.setTestSuite(null);
            }
            if (rename) {
                this.setStatus(Strings.get("ScriptRename", new Object[]{newFile.getName()}));
            } else {
                this.setStatus(Strings.get("ScriptSaved", new Object[]{newFile.getName()}));
            }
            this.view.getTestScriptSelector().repaint();
            String text = this.testScript != null ? this.testScript.getDescription() : "";
            this.view.getTestScriptDescription().setText(text);
        }
    }

    private boolean editingTempFile() {
        return this.testScript != null && this.testScript.getFile().equals(this.tempFile);
    }

    private void saveScript() {
        boolean canWrite;
        if (this.testScript == null) {
            Log.warn("null testScript");
            return;
        }
        if (this.editingTempFile()) {
            Log.debug("Directory is temporary directory, need to rename");
            this.saveAsScript(false);
            return;
        }
        File file = this.testScript.getFile();
        File parent = file.getParentFile();
        FileSystemHelper fileSystemHelper = this.editorConfiguration.getFileSystemHelper();
        boolean bl = canWrite = !file.exists() && fileSystemHelper.makeWritable(parent) || file.exists() && fileSystemHelper.makeWritable(file);
        if (!canWrite) {
            String msg = Strings.get("NoFilePermission", new Object[]{file.toString()});
            this.view.showError(Strings.get("SaveFailed.title"), msg);
        } else {
            try {
                this.setStatus(Strings.get("Saving", new Object[]{file}));
                this.saveNestedScripts(this.testScript);
                this.setStatus(Strings.get("Saved", new Object[]{file}));
            }
            catch (IOException exc) {
                this.view.showError(Strings.get("SaveFailed.title"), exc.toString());
            }
        }
    }

    void saveNestedScripts(Sequence seq) throws IOException {
        if (seq instanceof Script) {
            Script script = (Script)seq;
            File file = script.getFile();
            if (!this.editorConfiguration.getFileSystemHelper().makeWritable(file)) {
                throw new IOException(Strings.get("NoFilePermission", new Object[]{file.toString()}));
            }
            script.save();
        }
        Iterator iter = seq.steps().iterator();
        while (iter.hasNext()) {
            Step step = (Step)iter.next();
            if (!(step instanceof Sequence)) continue;
            this.saveNestedScripts((Sequence)step);
        }
    }

    private void startListening() {
        this.normalizer.startListening(new SingleThreadedEventListener(){

            protected void processEvent(AWTEvent event) {
                ScriptEditor.this.processEvent(event);
            }
        }, FIXTURE_EVENT_MASK);
        this.view.getComponentBrowser().setEnabled(true);
    }

    private int countShowingWindows(Window root) {
        Iterator iter;
        int count = root != null && root.isShowing() ? 1 : 0;
        Iterator iterator = iter = root == null ? this.hierarchy.getRoots().iterator() : this.hierarchy.getComponents(root).iterator();
        while (iter.hasNext()) {
            Component c = (Component)iter.next();
            if (!(c instanceof Window)) continue;
            count += this.countShowingWindows((Window)c);
        }
        return count;
    }

    private boolean isKeyPress(AWTEvent event, int code, int modifiers) {
        return event.getID() == 401 && ((KeyEvent)event).getKeyCode() == code && (((KeyEvent)event).getModifiers() == modifiers || modifiers == this.DONT_CARE);
    }

    private boolean isKeyRelease(AWTEvent event, int code, int modifiers) {
        return event.getID() == 402 && ((KeyEvent)event).getKeyCode() == code && (((KeyEvent)event).getModifiers() == modifiers || modifiers == this.DONT_CARE);
    }

    private void processEvent(AWTEvent event) {
        boolean isFiltered;
        Object src = event.getSource();
        boolean isComponent = src instanceof Component;
        boolean bl = isFiltered = isComponent && this.hierarchy.isFiltered((Component)src);
        if (this.isRootEditor && (LOG_ALL_EVENTS || !isFiltered && !this.ignoreEvents) && Boolean.getBoolean("abbot.fixture.log_events")) {
            Log.log("ED: " + Robot.toString(event) + " (" + Thread.currentThread() + ")");
        }
        if (!isComponent && !(src instanceof MenuComponent)) {
            Log.warn("Source not a Component or MenuComponent: " + event);
            return;
        }
        if (this.isScriptRunning) {
            return;
        }
        if (!(this.handleEditorTransient(event) || this.handleRecordingControl(event) || this.handleImageCaptureControl(event) || this.handleComponentSelection(event) || this.recorder == null || !this.recording || isFiltered)) {
            Log.debug("recorder process event");
            try {
                this.recorder.record(event);
            }
            catch (RecordingFailedException e) {
                this.stopRecording(false);
                String msg = Strings.get("editor.recording.failure");
                Throwable error = e.getReason() instanceof BugReport ? e.getReason() : new BugReport(msg, e.getReason());
                Log.log("Recording failure: " + error.toString());
                this.setStatus(error.getMessage(), error.toString(), 2);
                this.view.showWarning(msg);
            }
        }
        this.updateComponents(event);
    }

    private boolean handleComponentSelection(AWTEvent event) {
        Component ultimateComponent = state.getUltimateMouseComponent();
        if (ultimateComponent != null && !this.hierarchy.isFiltered(ultimateComponent)) {
            boolean keySelect = this.isKeyPress(event, selectKey, 1);
            boolean mouseSelect = event.getID() == 501 && AWT.isTertiaryButton(((MouseEvent)event).getModifiers());
            boolean makeReference = this.isKeyPress(event, selectKey, 9);
            if (keySelect || mouseSelect || makeReference) {
                Component selected = event instanceof MouseEvent ? InputState.getComponentAt((Component)event.getSource(), ((MouseEvent)event).getPoint()) : ultimateComponent;
                this.selectComponent(selected, makeReference);
                return true;
            }
        }
        return false;
    }

    private void updateComponents(AWTEvent event) {
        if (this.isKeyPress(event, 16, this.DONT_CARE)) {
            this.invertAssertions = true;
            this.view.setAssertOptions(this.waitAssertions, this.invertAssertions);
        } else if (this.isKeyRelease(event, 16, this.DONT_CARE)) {
            this.invertAssertions = false;
            this.view.setAssertOptions(this.waitAssertions, this.invertAssertions);
        } else if (this.isKeyPress(event, KC_WAIT, this.DONT_CARE)) {
            this.waitAssertions = true;
            this.view.setAssertOptions(this.waitAssertions, this.invertAssertions);
        } else if (this.isKeyRelease(event, KC_WAIT, this.DONT_CARE)) {
            this.waitAssertions = false;
            this.view.setAssertOptions(this.waitAssertions, this.invertAssertions);
        }
    }

    private boolean handleEditorTransient(AWTEvent event) {
        if (event.getID() == 200 && ((WindowEvent)event).getWindow().getParent() == this.view) {
            this.hierarchy.setFiltered(((WindowEvent)event).getWindow(), true);
            this.view.getComponentBrowser().refresh();
            return true;
        }
        return false;
    }

    private boolean handleImageCaptureControl(AWTEvent event) {
        Object src = event.getSource();
        boolean isComponent = event.getSource() instanceof Component;
        boolean isFiltered = isComponent && this.hierarchy.isFiltered((Component)event.getSource());
        Component ultimateComponent = state.getUltimateMouseComponent();
        if (this.capturingImage) {
            if (this.isKeyRelease(event, 27, 0)) {
                this.imageCaptureCancel();
            } else if (this.captureComponent != null && this.isKeyPress(event, 38, 0) && !(src instanceof Window)) {
                this.imageCaptureSelect(true);
            } else if (this.captureComponent != null && this.isKeyPress(event, 40, 0) && !(src instanceof Window)) {
                this.imageCaptureSelect(false);
            } else if (this.isKeyRelease(event, captureImageKey, 1) && !isFiltered && this.testScript != null && ultimateComponent != null) {
                this.imageCapture();
            }
            return true;
        }
        if (this.isKeyRelease(event, captureImageKey, 1) && !isFiltered && this.testScript != null && ultimateComponent != null) {
            this.imageCaptureStart(ultimateComponent);
            return true;
        }
        return false;
    }

    private boolean handleRecordingControl(AWTEvent e) {
        boolean isComponent;
        boolean isFiltered;
        boolean appGone;
        boolean editorActivated = e.getID() == 205 && e.getSource() == this.view;
        boolean bl = appGone = this.isAppLaunched() && this.countShowingWindows(null) == 0 && this.appGroup != null && this.appGroup.activeCount() == 0 && System.currentTimeMillis() - this.lastLaunchTime > 7500L;
        if (appGone) {
            Log.debug("Code under test no longer running");
        }
        boolean bl2 = isFiltered = (isComponent = e.getSource() instanceof Component) && this.hierarchy.isFiltered((Component)e.getSource());
        if (this.isKeyPress(e, captureKey, 1) || editorActivated || appGone) {
            Log.debug("stop recording trigger");
            if (this.recording) {
                this.stopRecording(false);
                this.justStoppedRecording = true;
                if (this.capturingImage) {
                    this.imageCaptureCancel();
                }
            } else {
                this.justStoppedRecording = false;
            }
            return true;
        }
        if (this.isKeyRelease(e, captureKey, 9)) {
            Log.debug("start recording trigger");
            if (!(isFiltered || this.recording || this.justStoppedRecording)) {
                Log.debug("Start recording events (+motion)");
                this.startRecording(this.recorders[1]);
                return true;
            }
        } else if (this.isKeyRelease(e, captureKey, 1)) {
            Log.debug("start recording trigger");
            if (!(isFiltered || this.recording || this.justStoppedRecording)) {
                Log.debug("Start recording events");
                this.startRecording(this.recorders[0]);
                return true;
            }
        }
        return false;
    }

    private void selectComponent(Component c, boolean makeReference) {
        Log.debug("Selected: " + Robot.toString(c));
        if (c != null && c.getParent() instanceof JComboBox) {
            c = c.getParent();
        }
        if (makeReference && this.getResolverContext() != null) {
            this.getResolverContext().addComponent(c);
        }
        this.view.getComponentBrowser().setSelectedComponent(c);
    }

    private void imageCaptureStart(Component ultimateComponent) {
        Log.debug("image capture locate");
        this.recording = false;
        this.capturingImage = true;
        this.innermostCaptureComponent = this.captureComponent = ultimateComponent;
        if (this.captureComponent instanceof JComponent) {
            this.highlighter = new Highlighter((JComponent)this.captureComponent);
        }
        this.setStatus("Image capture target is " + Robot.toString(this.captureComponent));
    }

    private void imageCaptureCancel() {
        Log.debug("stop image capture command");
        this.highlighter.dispose();
        this.setStatus("Image capture canceled");
        this.innermostCaptureComponent = null;
        this.captureComponent = null;
        this.capturingImage = false;
    }

    private void imageCaptureSelect(boolean up) {
        block3: {
            block2: {
                if (!up) break block2;
                Log.debug("image capture move up");
                Container parent = this.captureComponent.getParent();
                if (!(parent instanceof JComponent) || this.captureComponent instanceof JLayeredPane) break block3;
                Log.debug("Changing from " + Robot.toString(this.captureComponent) + " to " + Robot.toString(parent));
                this.highlighter.dispose();
                this.highlighter = new Highlighter((JComponent)parent);
                this.captureComponent = parent;
                break block3;
            }
            Log.debug("image capture move down");
            if (this.captureComponent instanceof Container) {
                Component[] subs = ((Container)this.captureComponent).getComponents();
                for (int i = 0; i < subs.length; ++i) {
                    if (!SwingUtilities.isDescendingFrom(this.innermostCaptureComponent, subs[i]) || !(subs[i] instanceof JComponent)) continue;
                    Log.debug("Changing from " + Robot.toString(this.captureComponent) + " to " + Robot.toString(subs[i]));
                    this.highlighter.dispose();
                    this.highlighter = new Highlighter((JComponent)subs[i]);
                    this.captureComponent = subs[i];
                    break;
                }
            }
        }
        this.setStatus("Image capture target is " + Robot.toString(this.captureComponent));
    }

    private void imageCapture() {
        Log.debug("image capture snapshot");
        this.setStatus("Capturing image...");
        this.view.repaint();
        this.highlighter.dispose();
        new Thread("wait for repaint"){

            public void run() {
                while (Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent() != null) {
                    try {
                        18.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Step step = ScriptEditor.this.captureComponentImage(ScriptEditor.this.captureComponent);
                        if (step != null) {
                            if (ScriptEditor.this.recorder != null) {
                                ScriptEditor.this.recorder.insertStep(step);
                            } else {
                                ScriptEditor.this.addStep(step);
                            }
                        }
                        ScriptEditor.this.setStatus("Capturing image...done");
                        ScriptEditor.this.captureComponent = (ScriptEditor.this.innermostCaptureComponent = null);
                        ScriptEditor.this.capturingImage = false;
                    }
                });
            }
        }.start();
    }

    private List getScripts() {
        if (this.testScriptList == null) {
            this.testScriptList = this.getScripts((Test)this.testSuite);
        }
        return this.testScriptList;
    }

    private List getScripts(Test node) {
        ArrayList<String> names = new ArrayList<String>();
        if (node != null) {
            if (node instanceof ScriptFixture) {
                names.add(((ScriptFixture)node).getName());
            } else if (node instanceof TestSuite) {
                Enumeration e = ((TestSuite)node).tests();
                while (e.hasMoreElements()) {
                    Test test = (Test)e.nextElement();
                    names.addAll(this.getScripts(test));
                }
            } else if (node instanceof TestDecorator) {
                Test base = ((TestDecorator)node).getTest();
                names.addAll(this.getScripts(base));
            }
        }
        return names;
    }

    private Script getScriptAt(int index) {
        List filenames = this.getScripts();
        if (index >= filenames.size()) {
            index = filenames.size() - 1;
        }
        return new Script((String)filenames.get(index), this.hierarchy);
    }

    private void insertTesterCall(ComponentTester tester, Method method, Class componentClass, String id, String[] argList, boolean wait, boolean invert) throws NoSuchReferenceException {
        String expectedResult = "true";
        String methodName = method.getName();
        if (methodName.startsWith("assert")) {
            Assert step;
            if (id == null) {
                step = new Assert(this.getResolverContext(), null, method.getDeclaringClass().getName(), methodName, argList, expectedResult, invert);
            } else {
                ComponentReference ref = this.getComponentReference(id);
                if (ref == null) {
                    throw new NoSuchReferenceException(id);
                }
                step = new Assert(this.getResolverContext(), null, methodName, argList, method.getDeclaringClass(), expectedResult, invert);
            }
            step.setWait(wait);
            this.addStep(step);
        } else if (methodName.startsWith("action")) {
            if (id == null) {
                this.addStep(new abbot.script.Action(this.getResolverContext(), null, methodName, argList));
            } else {
                ComponentReference ref = this.getComponentReference(id);
                if (ref == null) {
                    throw new NoSuchReferenceException(id);
                }
                this.addStep(new abbot.script.Action(this.getResolverContext(), null, methodName, argList, method.getDeclaringClass()));
            }
        } else {
            ComponentReference ref = this.getComponentReference(id);
            if (ref == null) {
                throw new NoSuchReferenceException(id);
            }
            this.addStep(new Assert(this.getResolverContext(), null, methodName, argList, tester.getTestedClass(componentClass), expectedResult, invert));
        }
    }

    private void reflectScriptExecutionState(StepEvent ev) {
        Step step = ev.getStep();
        String cmd = ev.getType();
        Log.debug("Got step event " + ev);
        if (cmd.equals("step-start")) {
            if (step == this.stopStep) {
                this.runner.stop();
                this.stopStep = null;
            }
            if (step != this.testScript) {
                final int row = this.scriptModel.getRowOf(step);
                if (row != -1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ScriptEditor.this.scriptTable.setRowSelectionInterval(row, row);
                            ScriptEditor.this.scriptTable.setCursorLocation(row + 1);
                            Rectangle rect = ScriptEditor.this.scriptTable.getCellRect(row, 0, true);
                            ScriptEditor.this.scriptTable.scrollRectToVisible(rect);
                        }
                    });
                }
                int i = this.testScript.indexOf(step);
                if (i != -1) {
                    this.setStatus(Strings.get("RunningStep", new Object[]{String.valueOf(i + 1), String.valueOf(this.testScript.size())}));
                }
            }
        } else if (cmd.equals("step-failure") || cmd.equals("step-error")) {
            int index = this.scriptModel.getRowOf(step);
            if (index != -1) {
                this.scriptModel.fireTableRowsUpdated(index, index);
            }
            this.setStatusForStep(step);
        }
    }

    Resolver getResolverContext() {
        return this.scriptTable.getScriptContext();
    }

    public ComponentReference getComponentReference(String refid) {
        return this.getResolverContext() != null ? this.getResolverContext().getComponentReference(refid) : null;
    }

    public ComponentReference getComponentReference(Component comp) {
        return this.getResolverContext() != null ? this.getResolverContext().getComponentReference(comp) : null;
    }

    public void addComponentReference(ComponentReference ref) {
        if (this.getResolverContext() == null) {
            throw new RuntimeException(Strings.get("NoContext"));
        }
        this.getResolverContext().addComponentReference(ref);
    }

    public ComponentReference addComponent(Component comp) {
        if (this.getResolverContext() == null) {
            throw new RuntimeException(Strings.get("NoContext"));
        }
        return this.getResolverContext().addComponent(comp);
    }

    public Collection getComponentReferences() {
        if (this.getResolverContext() == null) {
            return new HashSet();
        }
        return this.getResolverContext().getComponentReferences();
    }

    public String getContext(Step step) {
        Resolver r = this.getResolverContext();
        if (r != null) {
            return r.getContext(step);
        }
        return "unknown";
    }

    public File getDirectory() {
        if (this.getResolverContext() == null) {
            return new File(System.getProperty("user.dir"));
        }
        return this.getResolverContext().getDirectory();
    }

    public void setProperty(String name, Object value) {
        if (this.getResolverContext() != null) {
            this.getResolverContext().setProperty(name, value);
        }
    }

    public Object getProperty(String name) {
        if (this.getResolverContext() != null) {
            return this.getResolverContext().getProperty(name);
        }
        return null;
    }

    public ClassLoader getContextClassLoader() {
        if (this.getResolverContext() != null) {
            return this.getResolverContext().getContextClassLoader();
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public String toString() {
        return this.name;
    }

    private void stepSelectionChanged() {
        this.stopStep = null;
        this.setStepEditor();
        this.setActionsEnabledState();
    }

    private void setStepEditor(Step step) {
        StepEditor editor;
        this.ignoreEvents = true;
        if (step != null && (editor = StepEditor.getEditor(step)) != null) {
            this.view.setEditor(editor);
            editor.addStepChangeListener(new StepChangeListener(){

                public void stepChanged(Step step) {
                    int row = ScriptEditor.this.scriptModel.getRowOf(step);
                    if (row != -1) {
                        ScriptEditor.this.scriptModel.fireTableRowsUpdated(row, row);
                    }
                }
            });
        } else {
            Log.debug("No editor available for '" + step + "'");
            this.view.setEditor(null);
        }
        this.ignoreEvents = false;
        this.view.getComponentBrowser().setResolver(this.getResolverContext());
    }

    private static String usage() {
        return (class$abbot$editor$ScriptEditor == null ? (class$abbot$editor$ScriptEditor = ScriptEditor.class$("abbot.editor.ScriptEditor")) : class$abbot$editor$ScriptEditor).getName() + " [suite classname]";
    }

    private void setStepEditor() {
        Step step = this.scriptTable.getSelectedRowCount() == 1 ? this.scriptModel.getStepAt(this.scriptTable.getSelectedRow()) : null;
        this.setStepEditor(step);
        this.setStatusForStep(step);
        this.setActionsEnabledState();
    }

    private void hideView() {
        this.hiding = true;
        this.view.setVisible(false);
    }

    private void disposeView() {
        this.exiting = true;
        this.view.dispose();
    }

    void dispose() {
        this.terminate();
        this.normalizer.stopListening();
        this.hideView();
        this.disposeView();
        if (this.securityManager != null) {
            System.setSecurityManager(this.oldSecurityManager);
            this.securityManager = null;
        }
    }

    private static void bugCheck() {
        Window w = Costello.getSplashScreen();
        if (w != null) {
            String[] bugs = Bugs.bugCheck(Costello.getSplashScreen());
            for (int i = 0; i < bugs.length; ++i) {
                String title = Strings.get("BugWarning.title");
                String msg = TextFormat.dialog(bugs[i]);
                JOptionPane.showMessageDialog(w, msg, title, 2);
            }
        }
    }

    public static void main(String[] args) {
        ScriptEditor.showEditor(new EditorContext(args));
    }

    public static void showEditor(EditorContext ec) {
        try {
            String arg;
            String[] args = Log.init(ec.getArguments());
            ScriptEditor.bugCheck();
            if (args.length > 1) {
                if (ec.isEmbedded()) {
                    JOptionPane.showMessageDialog(null, "Invalid arguments when invoking abbot");
                    return;
                }
                System.err.println("usage: " + ScriptEditor.usage());
                System.exit(1);
            }
            editor = new ScriptEditor(ec);
            String string = arg = args.length == 1 ? args[0] : null;
            if (arg != null && new File(arg).exists() && Script.isScript(new File(arg))) {
                editor.setTestSuite(null);
                editor.setScript(arg);
            } else {
                editor.setTestSuite(arg);
                editor.setScript(0);
            }
            ScriptEditor.editor.hierarchy.ignoreExisting();
            ScriptEditor.editor.view.pack();
            ScriptEditor.editor.view.setVisible(true);
            editor.startListening();
        }
        catch (Throwable e) {
            if (editor != null) {
                editor.dispose();
            }
            System.err.println("Unexpected exception trying to launch the script editor");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private boolean isAppLaunched() {
        UIContext ctxt;
        if (this.editorConfiguration.isEmbedded()) {
            return true;
        }
        if (this.testScript != null && (ctxt = this.testScript.getUIContext()) != null) {
            return ctxt.isLaunched();
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            new EventExceptionHandler().install();
        }
        catch (Exception e) {
            // empty catch block
        }
        String key = System.getProperty("abbot.editor.select_key", "F1");
        selectKey = KeyStroke.getKeyStroke(key).getKeyCode();
        key = System.getProperty("abbot.editor.capture_key", "F2");
        captureKey = KeyStroke.getKeyStroke(key).getKeyCode();
        key = System.getProperty("abbot.editor.capture_image_key", "F3");
        captureImageKey = KeyStroke.getKeyStroke(key).getKeyCode();
        LOG_ALL_EVENTS = Boolean.getBoolean("abbot.editor.log_all_events");
        FIXTURE_EVENT_MASK = Long.getLong("abbot.fixture.event_mask", 2813L);
        KC_WAIT = Platform.isMacintosh() ? 18 : 17;
        statusFormat = new String[]{"Normal", "Warning", "Error", "Failure"};
        statusColor = new Color[]{Color.black, Color.orange.darker(), Color.red, Color.red};
        state = Robot.getState();
        editor = null;
    }

    private class EditorStepRunner
    extends StepRunner {
        public EditorStepRunner() {
            super(new AWTFixtureHelper());
        }

        public Hierarchy getHierarchy() {
            return ScriptEditor.this.hierarchy;
        }

        public void terminate() {
            super.terminate();
            ScriptEditor.this.setActionsEnabledState();
            ScriptEditor.this.view.getComponentBrowser().refresh();
        }
    }

    private class ToggleStopOnFailureAction
    extends EditorToggleAction {
        public ToggleStopOnFailureAction() {
            super("toggle-stop-on-failure");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.stopOnFailureToggle();
        }
    }

    private class ToggleStopOnErrorAction
    extends EditorToggleAction {
        public ToggleStopOnErrorAction() {
            super("toggle-stop-on-error");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.stopOnErrorToggle();
        }
    }

    private class ToggleAWTModeAction
    extends EditorToggleAction {
        public ToggleAWTModeAction() {
            super("toggle-awt-mode");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.awtModeToggle();
        }
    }

    private class ToggleSlowPlaybackAction
    extends EditorToggleAction {
        public ToggleSlowPlaybackAction() {
            super("toggle-slow-playback");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.slowPlaybackToggle();
        }
    }

    private class ToggleForkedAction
    extends EditorToggleAction {
        public ToggleForkedAction() {
            super("toggle-forked");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.forkedToggle();
        }
    }

    private class CaptureImageAction
    extends EditorAction {
        public CaptureImageAction() {
            super("capture-image");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(captureImageKey, 1));
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.view.showWarning(Strings.get("actions.capture-image.desc"));
        }
    }

    private class CaptureComponentAction
    extends EditorAction {
        public CaptureComponentAction() {
            super("capture-component");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(selectKey, 9));
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.view.showWarning(Strings.get("actions.capture-component.desc"));
        }
    }

    private class SelectComponentAction
    extends EditorAction {
        public SelectComponentAction() {
            super("select-component");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(selectKey, 1));
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.view.showWarning(Strings.get("actions.select-component.desc"));
        }
    }

    private class GetVMArgsAction
    extends EditorAction {
        public GetVMArgsAction() {
            super("run-get-vmargs");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.getVMArgs();
        }
    }

    private class InsertAnnotationAction
    extends EditorAction {
        public InsertAnnotationAction() {
            super("insert-annotation");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.insertAnnotation();
        }
    }

    private class InsertExpressionAction
    extends EditorAction {
        public InsertExpressionAction() {
            super("insert-expression");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.insertExpression();
        }
    }

    private class InsertCommentAction
    extends EditorAction {
        public InsertCommentAction() {
            super("insert-comment");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.insertComment();
        }
    }

    private class InsertScriptAction
    extends EditorAction {
        public InsertScriptAction() {
            super("insert-script");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.insertScript(false);
        }
    }

    private class InsertSequenceAction
    extends EditorAction {
        public InsertSequenceAction() {
            super("insert-sequence");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.insertSequence();
        }
    }

    private class InsertSampleAction
    extends EditorAction {
        public InsertSampleAction() {
            super("insert-sample");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.insertCall(true);
        }
    }

    private class InsertCallAction
    extends EditorAction {
        public InsertCallAction() {
            super("insert-call");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.insertCall(false);
        }
    }

    private class InsertTerminateAction
    extends EditorAction {
        public InsertTerminateAction() {
            super("insert-terminate");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.insertTerminate();
        }
    }

    private class InsertAppletAction
    extends EditorAction {
        public InsertAppletAction() {
            super("insert-applet");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.insertApplet();
        }
    }

    private class InsertFixtureAction
    extends EditorAction {
        public InsertFixtureAction() {
            super("insert-fixture");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.insertScript(true);
        }
    }

    private class InsertLaunchAction
    extends EditorAction {
        public InsertLaunchAction() {
            super("insert-launch");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.insertLaunch();
        }
    }

    private class RunTerminateAction
    extends EditorAction {
        public RunTerminateAction() {
            super("run-terminate");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.terminate();
        }
    }

    private class RunLaunchAction
    extends EditorAction {
        public RunLaunchAction() {
            super("run-launch");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.launch(true);
        }
    }

    private class SelectTestSuiteAction
    extends EditorAction {
        public SelectTestSuiteAction() {
            super("select-testsuite");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.browseTests();
        }
    }

    private class ExportHierarchyAction
    extends EditorAction {
        public ExportHierarchyAction() {
            super("export-hierarchy");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.exportHierarchy();
        }
    }

    private class RunToAction
    extends EditorAction {
        public RunToAction() {
            super("run-to");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.runScript(ScriptEditor.this.scriptTable.getSelectedStep());
        }
    }

    private class RunSelectedAction
    extends EditorAction {
        public RunSelectedAction() {
            super("run-selected");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.runSelectedSteps();
        }
    }

    private class RunAction
    extends EditorAction {
        public RunAction() {
            super("run");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.runScript(null);
        }
    }

    private class StepGroupAction
    extends EditorAction {
        public StepGroupAction() {
            super("step-group");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.groupSelection();
        }
    }

    private class StepMoveDownAction
    extends EditorAction {
        public StepMoveDownAction() {
            super("step-move-down");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.moveSelectionDown();
        }
    }

    private class StepMoveUpAction
    extends EditorAction {
        public StepMoveUpAction() {
            super("step-move-up");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.moveSelectionUp();
        }
    }

    private class StepCutAction
    extends EditorAction {
        public StepCutAction() {
            super("step-cut");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.cutSelection();
        }
    }

    private class ScriptCloseAction
    extends EditorAction {
        public ScriptCloseAction() {
            super("script-close");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.closeScript();
        }
    }

    private class ScriptRenameAction
    extends EditorAction {
        public ScriptRenameAction() {
            super("script-rename");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.saveAsScript(true);
        }
    }

    private class ScriptSaveAsAction
    extends EditorAction {
        public ScriptSaveAsAction() {
            super("script-save-as");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.saveAsScript(false);
        }
    }

    private class ScriptSaveAction
    extends EditorAction {
        public ScriptSaveAction() {
            super("script-save");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.saveScript();
        }
    }

    private class ScriptDeleteAction
    extends EditorAction {
        public ScriptDeleteAction() {
            super("script-delete");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.deleteScript();
        }
    }

    private class ScriptClearAction
    extends EditorAction {
        public ScriptClearAction() {
            super("script-clear");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.clearScript();
        }
    }

    private class ScriptOpenAction
    extends EditorAction {
        public ScriptOpenAction() {
            super("script-open");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.openScript();
        }
    }

    private class ScriptDuplicateAction
    extends EditorAction {
        public ScriptDuplicateAction() {
            super("script-duplicate");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.newScript(true);
        }
    }

    private class ScriptNewAction
    extends EditorAction {
        public ScriptNewAction() {
            super("script-new");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.newScript(false);
        }
    }

    private class EditorQuitAction
    extends EditorAction {
        public EditorQuitAction() {
            super("editor-quit");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.quitApplication();
        }
    }

    private class EditorUserGuideAction
    extends EditorAction {
        public EditorUserGuideAction() {
            super("editor-userguide");
        }

        public void actionPerformed(ActionEvent e) {
            new Thread("mailing-list"){

                public void run() {
                    try {
                        Launcher.open(Strings.get("editor.userguide"));
                    }
                    catch (IOException e) {
                        ScriptEditor.this.view.showWarning(e.getMessage());
                    }
                }
            }.start();
        }
    }

    private class EditorWebsiteAction
    extends EditorAction {
        public EditorWebsiteAction() {
            super("editor-website");
        }

        public void actionPerformed(ActionEvent e) {
            new Thread("mailing-list"){

                public void run() {
                    try {
                        Launcher.open(Strings.get("editor.website"));
                    }
                    catch (IOException e) {
                        ScriptEditor.this.view.showWarning(e.getMessage());
                    }
                }
            }.start();
        }
    }

    private class EditorBugReportAction
    extends EditorAction {
        public EditorBugReportAction() {
            super("editor-submit-bug");
        }

        public void actionPerformed(ActionEvent e) {
            new Thread("bug-report"){

                public void run() {
                    try {
                        Launcher.open(Strings.get("editor.submit_bug"));
                    }
                    catch (IOException e) {
                        ScriptEditor.this.view.showWarning(e.getMessage());
                    }
                }
            }.start();
        }
    }

    private class EditorEmailAction
    extends EditorAction {
        public EditorEmailAction() {
            super("editor-email");
        }

        public void actionPerformed(ActionEvent e) {
            new Thread("mailing-list"){

                public void run() {
                    try {
                        Launcher.mail(Strings.get("editor.email.list"), Strings.get("editor.email.subject"), Strings.get("editor.email.body", new Object[]{BugReport.getSystemInfo()}));
                    }
                    catch (IOException e) {
                        ScriptEditor.this.view.showWarning(e.getMessage());
                    }
                }
            }.start();
        }
    }

    private class EditorAboutAction
    extends EditorAction {
        public EditorAboutAction() {
            super("editor-about");
        }

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.view.showAboutBox();
        }
    }

    private class RecordAllAction
    extends EditorAction {
        private Recorder recorder;

        public RecordAllAction(String actionName, Recorder rec, boolean extraModifier) {
            super(actionName);
            this.recorder = rec;
            int mask = 1;
            if (extraModifier) {
                mask |= 8;
            }
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(captureKey, mask));
        }

        public void actionPerformed(ActionEvent ev) {
            Log.debug("Menu action: start recording due to " + ev.getActionCommand());
            ScriptEditor.this.startRecording(this.recorder);
        }
    }

    private class EditorSecurityManager
    extends NoExitSecurityManager {
        private EditorSecurityManager() {
        }

        public void checkRead(String file) {
        }

        public void checkExit(int status) {
            if (!ScriptEditor.this.rootIsExiting) {
                super.checkExit(status);
            }
        }

        protected void exitCalled(int status) {
            ScriptEditor.this.terminate();
        }
    }

    private class TesterMethodAction
    extends EditorAction
    implements Comparable {
        private Method method;
        private ComponentTester tester;
        private boolean wait;

        public TesterMethodAction(ComponentTester t, Method m, boolean w) {
            super(m.getName());
            this.putValue("Name", this.getName(m));
            this.putValue("SmallIcon", this.getIcon(m));
            this.wait = w;
            this.tester = t;
            this.method = m;
        }

        public int compareTo(Object o) {
            if (o instanceof TesterMethodAction) {
                return this.getName().compareTo(((TesterMethodAction)o).getName());
            }
            return 0;
        }

        public void actionPerformed(ActionEvent ev) {
            ScriptEditor.this.addTesterCall(this.method, this.tester, this.wait, this.getArgumentsDescription());
        }

        private String getName(Method m) {
            String name = m.getName();
            String menu = Strings.get(name + ".menu", true);
            if (menu == null && (menu = System.getProperty(name + ".menu")) == null) {
                menu = name.startsWith("action") || name.startsWith("assert") ? name.substring(6) : (name.startsWith("is") ? name.substring(2) : (name.startsWith("get") ? name.substring(3) : name));
                menu = TextFormat.wordBreak(menu);
            }
            return menu;
        }

        private Icon getIcon(Method m) {
            ImageIcon icon = null;
            String path = Strings.get(m.getName() + ".icon", true);
            if (path == null) {
                path = System.getProperty(m.getName() + ".icon");
            }
            if (path != null) {
                URL url = (class$abbot$editor$ScriptEditor == null ? (class$abbot$editor$ScriptEditor = ScriptEditor.class$("abbot.editor.ScriptEditor")) : class$abbot$editor$ScriptEditor).getResource(path);
                if (url == null) {
                    url = (class$abbot$editor$ScriptEditor == null ? (class$abbot$editor$ScriptEditor = ScriptEditor.class$("abbot.editor.ScriptEditor")) : class$abbot$editor$ScriptEditor).getResource("icons/" + path + ".gif");
                }
                if (url != null) {
                    icon = new ImageIcon(url);
                }
            }
            return icon;
        }

        private String getArgumentsDescription() {
            String name = this.method.getName();
            String cname = Robot.simpleClassName(this.method.getDeclaringClass());
            String args = Strings.get(cname + "." + name + ".args", true);
            if (args == null && (args = System.getProperty(cname + "." + name + ".args")) == null) {
                args = this.method.toString();
            }
            return args;
        }

        public String getName() {
            return (String)this.getValue("Name");
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof TesterMethodAction && this.getName().equals(((TesterMethodAction)o).getName());
        }
    }

    private class ScriptSelectorItemHandler
    implements ItemListener {
        private ScriptSelectorItemHandler() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (1 == e.getStateChange() && !ScriptEditor.this.ignoreComboBox) {
                if (ScriptEditor.this.checkSaveBeforeClose()) {
                    ScriptEditor.this.setScript(new Script((String)e.getItem(), ScriptEditor.this.hierarchy));
                } else {
                    ScriptEditor.this.setScript(ScriptEditor.this.testScript);
                }
            }
        }
    }

    private class ScriptTableSelectionHandler
    implements ListSelectionListener {
        private ScriptTableSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent ev) {
            if (ev.getValueIsAdjusting() || ScriptEditor.this.isScriptRunning) {
                return;
            }
            ScriptEditor.this.stepSelectionChanged();
        }
    }

    private class LaunchAction
    implements Runnable {
        private final Step which;
        private final Runnable onCompletion;
        private final String completionMessage;
        private final boolean launch;

        private LaunchAction(Step which, Runnable onCompletion, String completionMessage, boolean launch) {
            this.which = which;
            this.onCompletion = onCompletion;
            this.completionMessage = completionMessage;
            this.launch = launch;
        }

        public void run() {
            try {
                if (this.launch) {
                    if (this.which instanceof Script) {
                        UIContext context;
                        UIContext uIContext = context = this.which instanceof UIContext ? (UIContext)((Object)this.which) : ((Script)this.which).getUIContext();
                        if (context != null) {
                            context.launch(ScriptEditor.this.runner);
                        }
                    }
                } else {
                    ScriptEditor.this.runner.run(this.which);
                }
                if (this.completionMessage != null) {
                    ScriptEditor.this.setStatus(this.completionMessage);
                }
            }
            catch (Throwable e) {
                if (this.launch) {
                    ScriptEditor.this.terminate();
                }
                ScriptEditor.this.setStatus(e.getMessage(), ScriptEditor.this.getStackTrace(e), 2);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ScriptEditor.this.waiter != null) {
                        ScriptEditor.this.waiter.dispose();
                        ScriptEditor.this.waiter = null;
                    }
                    ScriptEditor.this.isScriptRunning = false;
                    ScriptEditor.this.setActionsEnabledState();
                    if (LaunchAction.this.onCompletion != null) {
                        LaunchAction.this.onCompletion.run();
                    }
                }
            });
        }
    }
}

