/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.Log;
import abbot.editor.recorder.WindowRecorder;
import abbot.script.Action;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.script.Step;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;

public class FrameRecorder
extends WindowRecorder {
    private Frame frame;
    private int newState;
    private int WINDOW_STATE_CHANGED = 209;
    static /* synthetic */ Class class$java$awt$Frame;

    public FrameRecorder(Resolver resolver) {
        super(resolver);
    }

    protected synchronized void init(int recordingType) {
        super.init(recordingType);
        this.frame = null;
    }

    protected boolean isWindowEvent(AWTEvent event) {
        return event.getSource() instanceof Frame && event.getID() == this.WINDOW_STATE_CHANGED || super.isWindowEvent(event);
    }

    protected boolean parseWindowEvent(AWTEvent event) {
        int id = event.getID();
        boolean consumed = true;
        if (id == this.WINDOW_STATE_CHANGED) {
            this.frame = (Frame)event.getSource();
            this.newState = this.getExtendedState(this.frame);
            this.setFinished(true);
        } else {
            consumed = super.parseWindowEvent(event);
        }
        return consumed;
    }

    protected Step createStep() {
        if (this.getRecordingType() == 1 && this.frame != null) {
            return this.createFrameStateChange(this.frame, this.newState);
        }
        return super.createStep();
    }

    protected Step createFrameStateChange(Frame frame, int newState) {
        ComponentReference ref = this.getResolver().addComponent(frame);
        return new Action(this.getResolver(), null, newState == 0 ? "actionNormalize" : "actionMaximize", new String[]{ref.getID()}, class$java$awt$Frame == null ? (class$java$awt$Frame = FrameRecorder.class$("java.awt.Frame")) : class$java$awt$Frame);
    }

    protected Step createResize(Window window, Dimension size) {
        Action step = null;
        if (((Frame)window).isResizable()) {
            ComponentReference ref = this.getResolver().addComponent(window);
            step = new Action(this.getResolver(), null, "actionResize", new String[]{ref.getID(), String.valueOf(size.width), String.valueOf(size.height)}, class$java$awt$Frame == null ? (class$java$awt$Frame = FrameRecorder.class$("java.awt.Frame")) : class$java$awt$Frame);
        }
        return step;
    }

    protected int getExtendedState(Frame frame) {
        try {
            Integer state = (Integer)(class$java$awt$Frame == null ? (class$java$awt$Frame = FrameRecorder.class$("java.awt.Frame")) : class$java$awt$Frame).getMethod("getExtendedState", new Class[0]).invoke((Object)frame, new Object[0]);
            Log.debug("State is " + state);
            return state;
        }
        catch (Exception e) {
            return frame.getState();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

