/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.abbot;

import abbot.Log;
import abbot.script.Script;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ScriptTestSuite
extends TestSuite {
    private File primaryDirectory = new File(System.getProperty("user.dir"));
    static /* synthetic */ Class class$junit$extensions$abbot$ScriptFixture;
    static /* synthetic */ Class class$java$lang$String;

    public ScriptTestSuite() {
        this(class$junit$extensions$abbot$ScriptFixture == null ? (class$junit$extensions$abbot$ScriptFixture = ScriptTestSuite.class$("junit.extensions.abbot.ScriptFixture")) : class$junit$extensions$abbot$ScriptFixture, System.getProperty("abbot.testsuite.path", System.getProperty("user.dir")), Boolean.getBoolean("abbot.testsuite.path.recurse"));
    }

    public ScriptTestSuite(Class fixtureClass) {
        this(fixtureClass, System.getProperty("user.dir"), false);
    }

    public ScriptTestSuite(Class fixtureClass, String dirname) {
        this(fixtureClass, dirname, false);
    }

    public ScriptTestSuite(Class fixtureClass, String dirname, boolean recurse) {
        this(fixtureClass, ScriptTestSuite.findFilenames(dirname, recurse));
        this.primaryDirectory = new File(dirname);
        if (!this.primaryDirectory.exists() || !this.primaryDirectory.isDirectory()) {
            String msg = "Directory '" + dirname + "' did not exist" + " when scanning for test scripts";
            this.addTest(this.warningTest(msg));
        }
    }

    public ScriptTestSuite(String[] filenames) {
        this(class$junit$extensions$abbot$ScriptFixture == null ? (class$junit$extensions$abbot$ScriptFixture = ScriptTestSuite.class$("junit.extensions.abbot.ScriptFixture")) : class$junit$extensions$abbot$ScriptFixture, filenames);
    }

    public ScriptTestSuite(Class fixtureClass, String[] filenames) {
        super(fixtureClass.getName());
        Log.debug("Loading " + fixtureClass + ", with " + filenames.length + " files");
        for (int i = 0; i < filenames.length; ++i) {
            File file = new File(filenames[i]);
            if (!this.accept(file)) continue;
            try {
                Log.debug("Attempting to create " + fixtureClass);
                Constructor ctor = fixtureClass.getConstructor(class$java$lang$String == null ? ScriptTestSuite.class$("java.lang.String") : class$java$lang$String);
                Test test = (Test)ctor.newInstance(file.getAbsolutePath());
                Log.debug("Created an instance of " + fixtureClass);
                this.addTest(test);
                continue;
            }
            catch (Throwable thr) {
                Log.warn(thr);
                this.addTest(this.warningTest("Could not construct an instance of " + fixtureClass));
                break;
            }
        }
        if (this.testCount() == 0) {
            this.addTest(this.warningTest("No scripts found"));
        }
    }

    public File getDirectory() {
        return this.primaryDirectory;
    }

    public boolean accept(File file) {
        String name = file.getName();
        return !name.startsWith(".#") && !name.endsWith("~") && !name.endsWith(".bak");
    }

    private Test warningTest(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                1.fail((String)message);
            }
        };
    }

    protected static List findTestScripts(File dir, List files, boolean recurse) {
        File[] flist = dir.listFiles();
        for (int i = 0; flist != null && i < flist.length; ++i) {
            String filename;
            if (flist[i].isDirectory()) {
                if (!recurse) continue;
                ScriptTestSuite.findTestScripts(flist[i], files, recurse);
                continue;
            }
            if (!Script.isScript(flist[i]) || files.contains(filename = flist[i].getAbsolutePath())) continue;
            Log.debug("Adding " + filename);
            files.add(filename);
        }
        return files;
    }

    static String[] findFilenames(String dirname, boolean recurse) {
        File dir = new File(dirname);
        ArrayList list = new ArrayList();
        if (dir.exists() && dir.isDirectory()) {
            ScriptTestSuite.findTestScripts(dir, list, recurse);
        }
        return list.toArray(new String[list.size()]);
    }

    public static void main(String[] args) {
        args = Log.init(args);
        ScriptTestSuite suite = new ScriptTestSuite(args);
        TestRunner runner = new TestRunner();
        try {
            TestResult r = runner.doRun((Test)suite, false);
            if (!r.wasSuccessful()) {
                System.exit(-1);
            }
            System.exit(0);
        }
        catch (Throwable thr) {
            System.err.println(thr.getMessage());
            System.exit(-2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

