/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.abbot;

import abbot.Log;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;

public class TestHelper {
    private static boolean printTestNames = false;
    static /* synthetic */ Class class$java$lang$String;

    protected TestHelper() {
    }

    public static File getClasspathDirectory(Class test) {
        URL url = test.getResource("/" + test.getName().replace('.', '/') + ".class");
        try {
            return new File(URLDecoder.decode(url.getFile(), "UTF-8")).getParentFile();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e.toString());
        }
    }

    public static TestSuite generateSuite(Class[] classes) {
        TestSuite suite = new TestSuite();
        for (int i = 0; i < classes.length; ++i) {
            try {
                Method suiteMethod = classes[i].getMethod("suite", null);
                suite.addTest((Test)suiteMethod.invoke(null, null));
                continue;
            }
            catch (Exception exc) {
                suite.addTest((Test)new TestSuite(classes[i]));
            }
        }
        return suite;
    }

    protected static String[] parseArgs(String[] args) {
        String language = System.getProperty("abbot.locale.language");
        if (language != null) {
            String country = System.getProperty("abbot.locale.country", "");
            String variant = System.getProperty("abbot.locale.language", "");
            Locale locale = new Locale(language, country, variant);
            Locale.setDefault(locale);
            System.out.println("Using locale " + locale.getDisplayName());
        }
        ArrayList<String> newArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-v")) {
                printTestNames = true;
                continue;
            }
            newArgs.add(args[i]);
        }
        return newArgs.toArray(new String[newArgs.size()]);
    }

    protected static Test collectTests(String[] args, Class testClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        TestSuite test;
        if (args.length == 1 && args[0].startsWith("test")) {
            try {
                test = (Test)testClass.newInstance();
                ((TestCase)test).setName(args[0]);
            }
            catch (InstantiationException e) {
                test = (Test)testClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = TestHelper.class$("java.lang.String")) : class$java$lang$String).newInstance(args[0]);
            }
        } else {
            try {
                test = (Test)testClass.getMethod("suite", null).invoke(null, null);
            }
            catch (Exception exc) {
                test = new TestSuite(testClass);
            }
        }
        return test;
    }

    protected static void runTest(Test test) {
        try {
            TestRunner runner = new TestRunner(new ResultPrinter(System.out){

                public void startTest(Test test) {
                    if (printTestNames) {
                        this.getWriter().print(test.toString());
                    }
                    super.startTest(test);
                }

                public void endTest(Test test) {
                    super.endTest(test);
                    if (printTestNames) {
                        this.getWriter().println();
                    }
                }
            });
            try {
                TestResult r = runner.doRun(test, false);
                if (!r.wasSuccessful()) {
                    System.exit(-1);
                }
                System.exit(0);
            }
            catch (Throwable thr) {
                System.err.println(thr.getMessage());
                System.exit(-2);
            }
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            System.exit(-2);
        }
    }

    public static void runTests(String[] args, Class testClass) {
        args = Log.init(args);
        args = TestHelper.parseArgs(args);
        try {
            TestHelper.runTest(TestHelper.collectTests(args, testClass));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(-2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

