/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.checkbox;

import java.awt.Container;
import java.util.List;
import junit.framework.Assert;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.context.DefaultContextVerifier;
import org.robotframework.swing.context.IContextVerifier;
import org.robotframework.swing.factory.OperatorListFactory;
import org.robotframework.swing.keyword.checkbox.CheckBoxListOperatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RobotKeywords
public class CheckBoxListKeywords {
    public static final String __PARANAMER_DATA = "\nallCheckboxesShouldBeChecked \n\nallCheckboxesShouldBeUnchecked \n\ncheckAllCheckboxes \n\nuncheckAllCheckboxes \n";
    private IContextVerifier contextVerifier = new DefaultContextVerifier();
    private OperatorListFactory<JCheckBoxOperator> operatorListFactory = new CheckBoxListOperatorFactory();

    @RobotKeyword(value="Checks all checkboxes in current context.\n\nExample:\n| Select Context | _My Checkbox Panel_ |\n| Check All Checkboxes | |\n")
    public void checkAllCheckboxes() {
        this.foreachCheckBox(new CheckBoxAction(){

            public void operateOnCheckBox(JCheckBoxOperator operator) {
                operator.changeSelection(true);
            }
        });
    }

    @RobotKeyword(value="Unchecks all checkboxes in current context.\n\nExample:\n| Select Context | _My Checkbox Panel_ |\n| Uncheck All Checkboxes | |\n")
    public void uncheckAllCheckboxes() {
        this.foreachCheckBox(new CheckBoxAction(){

            public void operateOnCheckBox(JCheckBoxOperator operator) {
                operator.changeSelection(false);
            }
        });
    }

    @RobotKeyword(value="Fails if any checkbox in current context is not checked.\n\nExample:\n| Select Context | _My Checkbox Panel_ |\n| All Checkboxes Should Be Checked | |\n")
    public void allCheckboxesShouldBeChecked() {
        this.foreachCheckBox(new CheckBoxAction(){

            public void operateOnCheckBox(JCheckBoxOperator operator) {
                Assert.assertTrue((String)("Checkbox '" + operator.getText() + "' is not checked."), (boolean)operator.isSelected());
            }
        });
    }

    @RobotKeyword(value="Fails if any checkbox in current context is checked.\n\nExample:\n| Select Context | _My Checkbox Panel_ |\n| All Checkboxes Should Be Unchecked | |\n")
    public void allCheckboxesShouldBeUnchecked() {
        this.foreachCheckBox(new CheckBoxAction(){

            public void operateOnCheckBox(JCheckBoxOperator operator) {
                Assert.assertFalse((String)("Checkbox '" + operator.getText() + "' is checked."), (boolean)operator.isSelected());
            }
        });
    }

    private List<JCheckBoxOperator> createOperators() {
        return this.operatorListFactory.createOperators((Container)Context.getContext().getSource());
    }

    private void foreachCheckBox(CheckBoxAction action) {
        this.contextVerifier.verifyContext();
        List<JCheckBoxOperator> operators = this.createOperators();
        for (JCheckBoxOperator checkBoxOperator : operators) {
            action.operateOnCheckBox(checkBoxOperator);
        }
    }

    private static interface CheckBoxAction {
        public void operateOnCheckBox(JCheckBoxOperator var1);
    }
}

