/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.internalframe;

import junit.framework.Assert;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.DefaultContextVerifier;
import org.robotframework.swing.context.IContextVerifier;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.internalframe.InternalFrameOperatorFactory;
import org.robotframework.swing.internalframe.MyInternalFrameOperator;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class InternalFrameKeywords {
    public static final String __PARANAMER_DATA = "\ncloseInternalFrame java.lang.String identifier \n\ninternalFrameShouldBeOpen java.lang.String identifier \n\ninternalFrameShouldExist java.lang.String identifier \n\ninternalFrameShouldNotBeOpen java.lang.String identifier \n\ninternalFrameShouldNotExist java.lang.String identifier \n";
    private IdentifierParsingOperatorFactory<MyInternalFrameOperator> operatorFactory = new InternalFrameOperatorFactory();
    private IComponentConditionResolver existenceResolver = new ComponentExistenceResolver(this.operatorFactory);
    private IContextVerifier contextVerifier = new DefaultContextVerifier();

    @RobotKeyword(value="Uses current context to search for an internal frame and closes it.\n\nExample:\n| Close Internal Frame  | _My Internal Frame_ |\n")
    public void closeInternalFrame(String identifier) {
        this.createOperator(identifier).close();
    }

    @RobotKeyword(value="Fails if the internal frame doesn't exist in the current context.\n\nExample:\n| Internal Frame Should Exist | _My Internal Frame_ |\n")
    public void internalFrameShouldExist(String identifier) {
        this.contextVerifier.verifyContext();
        Assert.assertTrue((String)("Internal frame '" + identifier + "' doesn't exist."), (boolean)this.existenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Fails if the internal frame exists in the current context.\n\nExample:\n| Internal Frame Should Not Exist | _My Internal Frame_ |\n")
    public void internalFrameShouldNotExist(String identifier) {
        this.contextVerifier.verifyContext();
        Assert.assertFalse((String)("Internal frame '" + identifier + "' exists."), (boolean)this.existenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Fails if the internal frame is *not* open.\n\nExample:\n| Internal Frame Should Be Open | _My Internal Frame_ |\n")
    public void internalFrameShouldBeOpen(String identifier) {
        Assert.assertTrue((String)("Internal frame '" + identifier + "' is not open."), (boolean)this.createOperator(identifier).isVisible());
    }

    @RobotKeyword(value="Fails if the internal frame *is* open.\n\nExample:\n| Internal Frame Should Not Be Open | _My Internal Frame_ |\n")
    public void internalFrameShouldNotBeOpen(String identifier) {
        Assert.assertFalse((String)("Internal frame '" + identifier + "' is open."), (boolean)this.createOperator(identifier).isVisible());
    }

    private MyInternalFrameOperator createOperator(String identifier) {
        this.contextVerifier.verifyContext();
        return this.operatorFactory.createOperator(identifier);
    }
}

