/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.menu;

import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.keyword.menu.MenuKeywords;
import org.robotframework.swing.keyword.menu.MenuSupport;
import org.robotframework.swing.keyword.window.WindowKeywords;

@RobotKeywords
public class MainMenuKeywords
extends MenuSupport {
    public static final String __PARANAMER_DATA = "\ngetMainMenuItemName java.lang.String index \n\nselectFromMainMenu java.lang.String menuPath \n\nselectFromMainMenuAndWait java.lang.String menuPath \n";
    private WindowKeywords windowKeywords = new WindowKeywords();
    private MenuKeywords menuKeywords = new MenuKeywords();

    @RobotKeyword(value="Selects an item from the menu of the window that was opened first.\nShortcut for:\n| Select Window    | _0_ |\n| Select From Menu | _Tools|Testing|MyTestTool_ |\n\nExample:\n| Select From Main Menu | _Tools|Testing|MyTestTool_ |\n")
    public void selectFromMainMenu(String menuPath) {
        this.windowKeywords.selectMainWindow();
        this.menuKeywords.selectFromMenu(menuPath);
    }

    @RobotKeyword(value="Selects an item from the menu of the window that was opened first and waits for action to finish.\nShortcut for:\n| Select Window             | _0_                        |\n| Select From Menu And Wait | _Tools|Testing|MyTestTool_ |\n\nThis keyword will not work, for example, if the menu item opens a dialog.\n\nExample:\n| Select From Main Menu And Wait | _Tools|Testing|MyTestTool_ |\n")
    public void selectFromMainMenuAndWait(String menuPath) {
        this.windowKeywords.selectMainWindow();
        this.menuKeywords.selectFromMenuAndWait(menuPath);
    }

    @RobotKeyword(value="Selects an item from the menu of the window that was opened first and returns it's name.\n\nExample:\n| ${mainMenuItemName}= | Get Main Menu Item Name | _0_                   |\n| Should Be Equal      | _File_                  | _${mainMenuItemName}_ |\n")
    public String getMainMenuItemName(String index) {
        if (!this.isIndex(index)) {
            throw new UnsupportedOperationException("The argument must be an index.");
        }
        return this.menubarOperator().getMenu(this.asIndex(index)).getText();
    }
}

