/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.table;

import junit.framework.Assert;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.Operator;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.common.IdentifierSupport;
import org.robotframework.swing.comparator.EqualsStringComparator;
import org.robotframework.swing.context.DefaultContextVerifier;
import org.robotframework.swing.context.IContextVerifier;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.table.TableOperator;
import org.robotframework.swing.table.TableOperatorFactory;

@RobotKeywords
public class TableKeywords
extends IdentifierSupport {
    public static final String __PARANAMER_DATA = "\ngetTableColumnCount java.lang.String identifier \n\ngetTableRowCount java.lang.String identifier \n\ngetSelectedTableCellValue java.lang.String identifier \n\ngetTableCellValue java.lang.String,java.lang.String,java.lang.String identifier,row,columnIdentifier \n\nclearTableCell java.lang.String,java.lang.String,java.lang.String identifier,row,columnIdentifier \n\nclearTableSelection java.lang.String identifier \n\nselectFromTableCellPopupMenu java.lang.String,java.lang.String,java.lang.String,java.lang.String identifier,row,columnIdentifier,menuPath \n\nselectTableCell java.lang.String,java.lang.String,java.lang.String identifier,row,cellIdentifier \n\nsetTableCellValue java.lang.String,java.lang.String,java.lang.String,java.lang.String identifier,row,columnIdentifier,newValue \n\ntableCellShouldBeSelected java.lang.String,java.lang.String,java.lang.String identifier,row,columnIdentifier \n\ntableCellShouldNotBeSelected java.lang.String,java.lang.String,java.lang.String identifier,row,columnIdentifier \n";
    private OperatorFactory<TableOperator> operatorFactory = new TableOperatorFactory();
    private IContextVerifier contextVerifier = new DefaultContextVerifier();

    @RobotKeyword(value="Selects a cell in a table.\n\nExample:\n| Select Table Cell | _myTable_ | _0_ | _2_       | # Selects cell from first row and third column |\n| Select Table Cell | _myTable_ | _1_ | _Keyword_ | # Selects cell from second row and column with header 'Keyword' |\n")
    public void selectTableCell(String identifier, String row, String cellIdentifier) {
        this.createTableOperator(identifier).selectCell(row, cellIdentifier);
    }

    @RobotKeyword(value="Clears selection from a table.\n\nExample:\n| Clear Table Selection | _myTable_ |\n")
    public void clearTableSelection(String identifier) {
        this.createTableOperator(identifier).clearSelection();
    }

    @RobotKeyword(value="Fails if given table cell is not selected in a table.\n\nExample:\n| Table Cell Should Be Selected | _myTable_ | _0_ | _2_       |\n| Table Cell Should Be Selected | _myTable_ | _1_ | _Keyword_ |\n")
    public void tableCellShouldBeSelected(String identifier, String row, String columnIdentifier) {
        TableOperator tableOperator = this.createTableOperator(identifier);
        Assert.assertTrue((String)("Cell '" + row + "', '" + columnIdentifier + "' is not selected."), (boolean)tableOperator.isCellSelected(row, columnIdentifier));
    }

    @RobotKeyword(value="Fails if given table cell is selected in a table.\n\nExample:\n| Table Cell Should Be Selected | _myTable_ | _0_ | _2_       |\n| Table Cell Should Be Selected | _myTable_ | _1_ | _Keyword_ |\n")
    public void tableCellShouldNotBeSelected(String identifier, String row, String columnIdentifier) {
        TableOperator tableOperator = this.createTableOperator(identifier);
        Assert.assertFalse((String)("Cell '" + row + "', '" + columnIdentifier + "' is selected."), (boolean)tableOperator.isCellSelected(row, columnIdentifier));
    }

    @RobotKeyword(value="Returns cell's value from a table.\n\nExample:\n| ${cellValue}=   | Get Table Cell Value | _myTable_ | _0_            | _2_ |\n| Should Be Equal | _tuesday_            |           | _${cellValue}_ |     |\n")
    public String getTableCellValue(String identifier, String row, String columnIdentifier) {
        return this.createTableOperator(identifier).getCellValue(row, columnIdentifier).toString();
    }

    @RobotKeyword(value="Returns selected cell's value from a table.\n\nExample:\n| ${cellValue}=   | Get Selected Table Cell Value   | _myTable_      |\n| Should Be Equal | _tuesday_                       | _${cellValue}_ |\n")
    public Object getSelectedTableCellValue(String identifier) {
        return this.createTableOperator(identifier).getSelectedCellValue().toString();
    }

    @RobotKeyword(value="Sets cell value in a table.\n\nExample:\n| Set Table Cell Value | _1_ | _2_ | _New value_ |\n")
    public void setTableCellValue(String identifier, String row, String columnIdentifier, String newValue) {
        TableOperator tableOperator = this.createTableOperator(identifier);
        tableOperator.setCellValue(newValue, row, columnIdentifier);
    }

    @RobotKeyword(value="Returns the number of columns from a table.\n\nExample:\n| ${columnCount}= | Get Table Column Count | _myTable_ |\n| Should Be Equal As Integers | _4_ | _${columnCount}_ |\n")
    public int getTableColumnCount(String identifier) {
        return this.createTableOperator(identifier).getColumnCount();
    }

    @RobotKeyword(value="Returns the number of rows from a table.\n\nExample:\n| ${rowCount}= | Get Table Row Count | _myTable_ |\n| Should Be Equal As Integers | _4_ | _${rowCount}_ |\n")
    public int getTableRowCount(String identifier) {
        return this.createTableOperator(identifier).getRowCount();
    }

    @RobotKeyword(value="Clears table cell contents.\n\nExample:\n| Clear Table Cell Value | _myTable_ | _1_ | _2_ |\n")
    public void clearTableCell(String identifier, String row, String columnIdentifier) {
        this.createTableOperator(identifier).clearCell(row, columnIdentifier);
    }

    @RobotKeyword(value="Selects an item from a table cell popup.\nSeparator for items is '|'.\n\nExamples:\n| Select From Table Cell Popup Menu | _myTable_ | _1_ | _3_ | _Cell Actions|Clear Cell Value_ | ")
    public void selectFromTableCellPopupMenu(String identifier, String row, String columnIdentifier, String menuPath) {
        TableOperator tableOperator = this.createTableOperator(identifier);
        JPopupMenuOperator popupMenuOperator = tableOperator.callPopupOnCell(row, columnIdentifier);
        JMenuItemOperator menuItem = popupMenuOperator.showMenuItem(menuPath, (Operator.StringComparator)new EqualsStringComparator());
        menuItem.push();
    }

    private TableOperator createTableOperator(String identifier) {
        this.contextVerifier.verifyContext();
        return this.operatorFactory.createOperator(identifier);
    }
}

